/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.integration.appleskin;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import squeek.appleskin.ModConfig;
import squeek.appleskin.api.event.FoodValuesEvent;
import squeek.appleskin.api.event.HUDOverlayEvent;
import squeek.appleskin.api.food.FoodValues;
import squeek.appleskin.client.HUDOverlayHandler;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.helpers.TextureHelper;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.mixin.client.integration.appleskin.HUDOverlayHandlerAccessor;
import umpaz.brewinandchewin.common.registry.BnCEffects;

public class TipsyAppleSkinCompat {
    public static final ResourceLocation MINECRAFT_ICONS = new ResourceLocation("textures/gui/icons.png");
    public static final ResourceLocation APPLESKIN_ICONS = new ResourceLocation("appleskin", "textures/icons.png");

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(TipsyAppleSkinCompat::preventSaturationInAppleSkin);
        MinecraftForge.EVENT_BUS.addListener(TipsyAppleSkinCompat::renderAppleSkinSaturation);
        MinecraftForge.EVENT_BUS.addListener(TipsyAppleSkinCompat::renderAppleSkinRestored);
    }

    public static void renderAppleSkinFoodWithIntoxication(RenderGuiOverlayEvent.Pre event, int foodIconsOffset) {
        boolean shouldRenderHeldItemValues;
        if (!HUDOverlayHandlerAccessor.brewinandchewin$shouldRenderAnyOverlays()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        assert (player != null);
        FoodData stats = player.m_36324_();
        int top = mc.m_91268_().m_85446_() - foodIconsOffset;
        int left = mc.m_91268_().m_85445_() / 2 - 91;
        int right = mc.m_91268_().m_85445_() / 2 + 91;
        HUDOverlayHandlerAccessor.brewinandchewin$generateHungerBarOffsets(top, left, right, mc.f_91065_.m_93079_(), (Player)player);
        HUDOverlayEvent.Saturation saturationRenderEvent = new HUDOverlayEvent.Saturation(stats.m_38722_(), right, top, event.getGuiGraphics());
        if (!((Boolean)ModConfig.SHOW_SATURATION_OVERLAY.get()).booleanValue()) {
            saturationRenderEvent.setCanceled(true);
        }
        if (!saturationRenderEvent.isCanceled()) {
            MinecraftForge.EVENT_BUS.post((Event)saturationRenderEvent);
        }
        if (!saturationRenderEvent.isCanceled()) {
            HUDOverlayHandler.drawSaturationOverlay((float)0.0f, (float)mc.f_91074_.m_36324_().m_38722_(), (Minecraft)mc, (GuiGraphics)event.getGuiGraphics(), (int)right, (int)top, (float)1.0f);
        }
        ItemStack heldItem = player.m_21205_();
        if (((Boolean)ModConfig.SHOW_FOOD_VALUES_OVERLAY_WHEN_OFFHAND.get()).booleanValue() && !FoodHelper.canConsume((ItemStack)heldItem, (Player)player)) {
            heldItem = player.m_21206_();
        }
        boolean bl = shouldRenderHeldItemValues = !heldItem.m_41619_() && FoodHelper.canConsume((ItemStack)heldItem, (Player)player);
        if (!shouldRenderHeldItemValues) {
            HUDOverlayHandler.resetFlash();
            return;
        }
        FoodValues modifiedFoodValues = FoodHelper.getModifiedFoodValues((ItemStack)heldItem, (Player)player);
        FoodValuesEvent foodValuesEvent = new FoodValuesEvent((Player)player, heldItem, FoodHelper.getDefaultFoodValues((ItemStack)heldItem, (Player)player), modifiedFoodValues);
        MinecraftForge.EVENT_BUS.post((Event)foodValuesEvent);
        modifiedFoodValues = foodValuesEvent.modifiedFoodValues;
        if (!((Boolean)ModConfig.SHOW_FOOD_VALUES_OVERLAY.get()).booleanValue()) {
            return;
        }
        HUDOverlayEvent.HungerRestored renderRenderEvent = new HUDOverlayEvent.HungerRestored(stats.m_38702_(), heldItem, modifiedFoodValues, saturationRenderEvent.x, saturationRenderEvent.y, event.getGuiGraphics());
        MinecraftForge.EVENT_BUS.post((Event)renderRenderEvent);
        if (renderRenderEvent.isCanceled()) {
            return;
        }
        int foodHunger = modifiedFoodValues.hunger;
        float foodSaturationIncrement = modifiedFoodValues.getSaturationIncrement();
        HUDOverlayHandler.drawHungerOverlay((int)foodHunger, (int)renderRenderEvent.currentFoodLevel, (Minecraft)mc, (GuiGraphics)event.getGuiGraphics(), (int)renderRenderEvent.x, (int)renderRenderEvent.y, (float)HUDOverlayHandlerAccessor.brewinandchewin$flashAlpha(), (boolean)FoodHelper.isRotten((ItemStack)heldItem, (Player)player));
        assert (saturationRenderEvent != null);
        if (!saturationRenderEvent.isCanceled()) {
            int newFoodValue = stats.m_38702_() + foodHunger;
            float newSaturationValue = stats.m_38722_() + foodSaturationIncrement;
            float saturationGained = newSaturationValue > (float)newFoodValue ? (float)newFoodValue - stats.m_38722_() : foodSaturationIncrement;
            HUDOverlayHandler.drawSaturationOverlay((float)saturationGained, (float)saturationRenderEvent.saturationLevel, (Minecraft)mc, (GuiGraphics)event.getGuiGraphics(), (int)saturationRenderEvent.x, (int)saturationRenderEvent.y, (float)HUDOverlayHandlerAccessor.brewinandchewin$flashAlpha());
        }
    }

    public static void preventSaturationInAppleSkin(FoodValuesEvent event) {
        Player entity = event.player;
        if (entity.m_21023_((MobEffect)BnCEffects.INTOXICATION.get())) {
            event.modifiedFoodValues = new FoodValues(event.modifiedFoodValues.hunger, 0.0f);
        }
    }

    public static void renderAppleSkinSaturation(HUDOverlayEvent.Saturation event) {
        if (!((Boolean)BnCConfiguration.INTOXICATION_FOOD_OVERLAY.get()).booleanValue() || !Minecraft.m_91087_().f_91074_.m_21023_((MobEffect)BnCEffects.INTOXICATION.get())) {
            return;
        }
        if (event.saturationLevel < 0.0f) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.blendFunc((int)770, (int)771);
        float modifiedSaturation = Math.max(0.0f, Math.min(event.saturationLevel, 20.0f));
        int startSaturationBar = 0;
        int endSaturationBar = (int)Math.ceil(modifiedSaturation / 2.0f);
        int iconSize = 9;
        int left = event.x;
        int ticks = Minecraft.m_91087_().f_91065_.m_93079_();
        for (int i = startSaturationBar; i < endSaturationBar; ++i) {
            int x = left - i * 8 - 9 + (int)(Mth.m_14089_((float)((float)(ticks + i * 2) * 0.2f)) * 2.0f);
            int y = event.y + (int)(Mth.m_14031_((float)((float)(ticks + i * 2) * 0.25f)) * 2.0f);
            int v = 0;
            int u = 0;
            float effectiveSaturationOfBar = modifiedSaturation / 2.0f - (float)i;
            if (effectiveSaturationOfBar >= 1.0f) {
                u = 3 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.5) {
                u = 2 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.25) {
                u = iconSize;
            }
            event.guiGraphics.m_280218_(APPLESKIN_ICONS, x, y, u, v, iconSize, iconSize);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MINECRAFT_ICONS);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        event.setCanceled(true);
    }

    public static void renderAppleSkinRestored(HUDOverlayEvent.HungerRestored event) {
        if (!((Boolean)BnCConfiguration.INTOXICATION_FOOD_OVERLAY.get()).booleanValue() || !Minecraft.m_91087_().f_91074_.m_21023_((MobEffect)BnCEffects.INTOXICATION.get())) {
            return;
        }
        if (event.foodValues.hunger < 0) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int modifiedFood = Math.max(0, Math.min(20, event.currentFoodLevel + event.foodValues.hunger));
        int startFoodBars = Math.max(0, event.currentFoodLevel / 2);
        int endFoodBars = (int)Math.ceil((float)modifiedFood / 2.0f);
        int iconStartOffset = 16;
        int iconSize = 9;
        int left = event.x;
        int ticks = Minecraft.m_91087_().f_91065_.m_93079_();
        for (int i = startFoodBars; i < endFoodBars; ++i) {
            int x = left - i * 8 - 9 + (int)(Mth.m_14089_((float)((float)(ticks + i * 2) * 0.2f)) * 2.0f);
            int y = event.y + (int)(Mth.m_14031_((float)((float)(ticks + i * 2) * 0.25f)) * 2.0f);
            int v = 3 * iconSize;
            int u = iconStartOffset + 4 * iconSize;
            int ub = iconStartOffset + iconSize;
            if (FoodHelper.isRotten((ItemStack)event.itemStack, (Player)Minecraft.m_91087_().f_91074_)) {
                u += 4 * iconSize;
                ub += 12 * iconSize;
            }
            if (i * 2 + 1 == modifiedFood) {
                u += iconSize;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(HUDOverlayHandlerAccessor.brewinandchewin$flashAlpha() * 0.25f));
            event.guiGraphics.m_280218_(TextureHelper.MC_ICONS, x, y, ub, v, iconSize, iconSize);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)HUDOverlayHandlerAccessor.brewinandchewin$flashAlpha());
            event.guiGraphics.m_280218_(TextureHelper.MC_ICONS, x, y, u, v, iconSize, iconSize);
        }
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        event.setCanceled(true);
    }
}

