/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import umpaz.brewinandchewin.common.registry.BnCParticleTypes;

public abstract class RagingParticleOptions
implements ParticleOptions {
    private final float size;

    public RagingParticleOptions(float size) {
        this.size = size;
    }

    public float size() {
        return this.size;
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeFloat(this.size);
    }

    public String m_5942_() {
        return "";
    }

    public static <T extends RagingParticleOptions> Codec<T> createCodec(Function<T, Float> sizeFunction, Function<Float, T> constructor) {
        return RecordCodecBuilder.create(inst -> inst.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("size").forGetter(sizeFunction)).apply((Applicative)inst, constructor));
    }

    public static <T extends RagingParticleOptions> ParticleOptions.Deserializer<T> createDeserializer(final Function<Float, T> constructor) {
        return new ParticleOptions.Deserializer<T>(){

            public T fromCommand(ParticleType<T> type, StringReader reader) throws CommandSyntaxException {
                float size = reader.readFloat();
                return (RagingParticleOptions)constructor.apply(Float.valueOf(size));
            }

            public T fromNetwork(ParticleType<T> type, FriendlyByteBuf buf) {
                return (RagingParticleOptions)constructor.apply(Float.valueOf(buf.readFloat()));
            }
        };
    }

    public static class StageFour
    extends RagingParticleOptions {
        public static final Codec<StageFour> CODEC = StageFour.createCodec(RagingParticleOptions::size, StageFour::new);
        public static final ParticleOptions.Deserializer<StageFour> DESERIALIZER = StageFour.createDeserializer(StageFour::new);

        public StageFour(float size) {
            super(size);
        }

        public ParticleType<?> m_6012_() {
            return (ParticleType)BnCParticleTypes.RAGING_STAGE_4.get();
        }
    }

    public static class StageThree
    extends RagingParticleOptions {
        public static final Codec<StageThree> CODEC = StageThree.createCodec(RagingParticleOptions::size, StageThree::new);
        public static final ParticleOptions.Deserializer<StageThree> DESERIALIZER = StageThree.createDeserializer(StageThree::new);

        public StageThree(float size) {
            super(size);
        }

        public ParticleType<?> m_6012_() {
            return (ParticleType)BnCParticleTypes.RAGING_STAGE_3.get();
        }
    }

    public static class StageTwo
    extends RagingParticleOptions {
        public static final Codec<StageTwo> CODEC = StageTwo.createCodec(RagingParticleOptions::size, StageTwo::new);
        public static final ParticleOptions.Deserializer<StageTwo> DESERIALIZER = StageTwo.createDeserializer(StageTwo::new);

        public StageTwo(float size) {
            super(size);
        }

        public ParticleType<?> m_6012_() {
            return (ParticleType)BnCParticleTypes.RAGING_STAGE_2.get();
        }
    }

    public static class StageOne
    extends RagingParticleOptions {
        public static final Codec<StageOne> CODEC = StageOne.createCodec(RagingParticleOptions::size, StageOne::new);
        public static final ParticleOptions.Deserializer<StageOne> DESERIALIZER = StageOne.createDeserializer(StageOne::new);

        public StageOne(float size) {
            super(size);
        }

        public ParticleType<?> m_6012_() {
            return (ParticleType)BnCParticleTypes.RAGING_STAGE_1.get();
        }
    }
}

