/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.common.block.entity.CoasterBlockEntity;

public class CoasterBlock
extends BaseEntityBlock {
    public static final IntegerProperty ROTATION = BlockStateProperties.f_61390_;
    public static final IntegerProperty SIZE = IntegerProperty.m_61631_((String)"size", (int)0, (int)4);
    public static final BooleanProperty INVISIBLE = BooleanProperty.m_61465_((String)"invisible");
    protected static final VoxelShape COASTER_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    protected static final VoxelShape TRAY_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);

    public CoasterBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50348_).m_60918_(SoundType.f_56736_).m_60966_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0))).m_61124_((Property)SIZE, (Comparable)Integer.valueOf(0))).m_61124_((Property)INVISIBLE, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        int size = (Integer)state.m_61143_((Property)SIZE);
        return size > 1 ? TRAY_SHAPE : COASTER_SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)INVISIBLE) != false ? Shapes.m_83040_() : super.m_5939_(state, worldIn, pos, context);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof CoasterBlockEntity) {
            CoasterBlockEntity coasterBlockEntity = (CoasterBlockEntity)blockEntity;
            return coasterBlockEntity.onUse(worldIn, state, pos, player, handIn);
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.m_246374_((float)(context.m_7074_() + 180.0f))));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos floorPos = pos.m_7495_();
        return CoasterBlock.m_49936_((BlockGetter)level, (BlockPos)floorPos) || CoasterBlock.m_49863_((LevelReader)level, (BlockPos)floorPos, (Direction)Direction.UP);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ROTATION, SIZE, INVISIBLE});
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(pRot.m_55949_(((Integer)pState.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return (BlockState)pState.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(pMirror.m_54843_(((Integer)pState.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CoasterBlockEntity) {
                CoasterBlockEntity be = (CoasterBlockEntity)blockEntity;
                Containers.m_19010_((Level)level, (BlockPos)pos, be.getItems());
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, moved);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return Math.min((Integer)blockState.m_61143_((Property)SIZE) * 4, 15);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        CoasterBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof CoasterBlockEntity && (blockEntity = (CoasterBlockEntity)blockEntity2).getItems().stream().anyMatch(stack -> !stack.m_41619_())) {
            List<ItemStack> stacks = blockEntity.getItems().stream().filter(stack -> !stack.m_41619_()).toList();
            return stacks.get(stacks.size() - 1);
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CoasterBlockEntity(pPos, pState);
    }
}

