/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.network.serverbound;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.compress.utils.Lists;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;

public record EMIFillPouringRecipeServerboundPacket(int syncId, int action, List<ItemStack> stacks) {
    public EMIFillPouringRecipeServerboundPacket(KegMenu menu, int action, List<ItemStack> stacks) {
        this(menu.f_38840_, action, stacks);
    }

    public static EMIFillPouringRecipeServerboundPacket decode(FriendlyByteBuf buf) {
        return new EMIFillPouringRecipeServerboundPacket(buf.readInt(), (int)buf.readByte(), (List<ItemStack>)buf.m_236845_(FriendlyByteBuf::m_130267_));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.syncId);
        buf.writeByte(this.action);
        buf.m_130130_(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            buf.m_130055_(stack);
        }
    }

    public static class Handler {
        public static void handle(EMIFillPouringRecipeServerboundPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
                if (sender == null || !ModList.get().isLoaded("emi")) {
                    return;
                }
                AbstractContainerMenu menu = sender.f_36096_;
                if (menu.f_38840_ != packet.syncId || !(menu instanceof KegMenu)) {
                    BrewinAndChewin.LOG.error("Attempted to transfer fermenting recipe to an incorrect menu");
                    return;
                }
                KegMenu kegMenu = (KegMenu)menu;
                ArrayList rubble = Lists.newArrayList();
                try {
                    for (ItemStack stack : packet.stacks) {
                        if (stack.m_41619_()) continue;
                        int gotten = Handler.grabMatching(kegMenu, (Player)sender, List.of(menu.m_38853_(4)), rubble, stack);
                        if (gotten != stack.m_41613_()) {
                            if (gotten > 0) {
                                stack.m_41764_(gotten);
                                sender.m_150109_().m_150079_(stack);
                            }
                            break;
                        }
                        Slot s = menu.m_38853_(5);
                        for (ItemStack item : kegMenu.blockEntity.extractInGui(stack, gotten)) {
                            if ((s.m_7993_().m_41619_() || ItemStack.m_150942_((ItemStack)item, (ItemStack)s.m_7993_())) && s.m_7993_().m_41613_() < item.m_41741_() && s.m_7993_().m_41613_() + item.m_41613_() < s.m_6641_()) {
                                s.m_5852_(item);
                                continue;
                            }
                            sender.m_150109_().m_150079_(item);
                        }
                        if (packet.action == 1) {
                            menu.m_150399_(5, 0, ClickType.PICKUP, (Player)sender);
                            continue;
                        }
                        if (packet.action != 2) continue;
                        menu.m_150399_(5, 0, ClickType.QUICK_MOVE, (Player)sender);
                    }
                }
                finally {
                    for (ItemStack stack : rubble) {
                        sender.m_150109_().m_150079_(stack);
                    }
                }
            });
        }

        private static int grabMatching(KegMenu menu, Player player, List<Slot> crafting, List<ItemStack> rubble, ItemStack stack) {
            int amount = stack.m_41613_();
            int grabbed = 0;
            for (int i = 0; i < rubble.size(); ++i) {
                if (grabbed >= amount) {
                    return grabbed;
                }
                ItemStack r = rubble.get(i);
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)r)) continue;
                int wanted = amount - grabbed;
                if (r.m_41613_() <= wanted) {
                    grabbed += r.m_41613_();
                    rubble.remove(i);
                    --i;
                    continue;
                }
                grabbed = amount;
                r.m_41764_(r.m_41613_() - wanted);
            }
            for (Slot s : menu.f_38839_) {
                ItemStack st;
                if (grabbed >= amount) {
                    return grabbed;
                }
                if (crafting.contains(s) || !s.m_8010_(player) || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)(st = s.m_7993_()))) continue;
                int wanted = amount - grabbed;
                ItemStack taken = st.m_41777_();
                if (st.m_41613_() <= wanted) {
                    grabbed += st.m_41613_();
                    s.m_269060_(ItemStack.f_41583_);
                } else {
                    grabbed = amount;
                    st.m_41764_(st.m_41613_() - wanted);
                }
                s.m_142406_(player, taken);
            }
            return grabbed;
        }
    }
}

