/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtquark;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.world.module.BlossomTreesModule;

public class BlossomLeavesProperties
extends LeavesProperties {
    public static final TypedRegistry.EntryType<LeavesProperties> TYPE = TypedRegistry.newType(BlossomLeavesProperties::new);

    public BlossomLeavesProperties(ResourceLocation registryName) {
        super(registryName);
    }

    @Nonnull
    protected DynamicLeavesBlock createDynamicLeaves(@Nonnull BlockBehaviour.Properties properties) {
        return new DynamicLeavesBlock(this, properties){

            @OnlyIn(value=Dist.CLIENT)
            public void m_214162_(@NotNull BlockState stateIn, Level worldIn, BlockPos pos, @NotNull RandomSource rand) {
                if (BlossomTreesModule.dropLeafParticles && rand.m_188503_(5) == 0 && worldIn.m_46859_(pos.m_7495_())) {
                    double windStrength = 5.0 + Math.cos((double)worldIn.m_46467_() / 2000.0) * 2.0;
                    double windX = Math.cos((double)worldIn.m_46467_() / 1200.0) * windStrength;
                    double windZ = Math.sin((double)worldIn.m_46467_() / 1000.0) * windStrength;
                    worldIn.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, stateIn), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, windX, -1.0, windZ);
                }
                super.m_214162_(stateIn, worldIn, pos, rand);
            }
        };
    }
}

