/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtquark;

import com.ferreusveritas.dynamictrees.api.GatherDataHelper;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.rooty.SoilProperties;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictreesplus.block.mushroom.CapProperties;
import maxhyper.dtquark.DTQuarkRegistries;
import maxhyper.dtquark.PlusRegistries;
import maxhyper.dtquark.loot.LootModifiers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.violetmoon.quark.content.world.module.BlossomTreesModule;
import org.violetmoon.zeta.config.type.CompoundBiomeConfig;

@Mod(value="dtquark")
public class DynamicTreesQuark {
    public static final String MOD_ID = "dtquark";

    public DynamicTreesQuark() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::gatherData);
        if (ModList.get().isLoaded("dynamictreesplus")) {
            modEventBus.register(PlusRegistries.class);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        LootModifiers.register(modEventBus);
        RegistryHandler.setup((String)MOD_ID);
    }

    private void clientSetup(FMLClientSetupEvent event) {
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        DTQuarkRegistries.setup();
        for (BlossomTreesModule.BlossomTree tree : BlossomTreesModule.blossomTrees) {
            tree.quarkConfig.biomeConfig = CompoundBiomeConfig.fromBiomeTags((boolean)false, (TagKey[])new TagKey[0]);
        }
    }

    private void gatherData(GatherDataEvent event) {
        GatherDataHelper.gatherAllData((String)MOD_ID, (GatherDataEvent)event, (Registry[])new Registry[]{SoilProperties.REGISTRY, Family.REGISTRY, Species.REGISTRY, Fruit.REGISTRY, LeavesProperties.REGISTRY, CapProperties.REGISTRY});
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

