/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtquark.cell;

import com.ferreusveritas.dynamictrees.api.cell.Cell;
import com.ferreusveritas.dynamictrees.api.cell.CellKit;
import com.ferreusveritas.dynamictrees.api.cell.CellNull;
import com.ferreusveritas.dynamictrees.api.cell.CellSolver;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.cell.CellKits;
import com.ferreusveritas.dynamictrees.cell.ConiferBranchCell;
import com.ferreusveritas.dynamictrees.cell.ConiferTopBranchCell;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import maxhyper.dtquark.DynamicTreesQuark;
import maxhyper.dtquark.cell.AncientLeafCell;

public class DTQuarkCellKits {
    public static final CellKit ANCIENT = new CellKit(DynamicTreesQuark.location("ancient")){
        private final Cell branchCell = new ConiferBranchCell();
        private final Cell topBranchCell = new ConiferTopBranchCell();
        private final Cell[] leafCells = new Cell[]{CellNull.NULL_CELL, new AncientLeafCell(1), new AncientLeafCell(2), new AncientLeafCell(3), new AncientLeafCell(4), new AncientLeafCell(5), new AncientLeafCell(6), new AncientLeafCell(7)};
        private final CellKits.BasicSolver solver = new CellKits.BasicSolver(new short[]{1300, 1043, 786, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.leafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.topBranchCell;
            }
            if (radius == 1) {
                return this.branchCell;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return AncientLeafCell.LEAF_CLUSTER;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };

    public static void register(Registry<CellKit> registry) {
        registry.register((RegistryEntry)ANCIENT);
    }
}

