/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtquark.growthlogic;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class AncientLogic
extends GrowthLogicKit {
    public static final ConfigurationProperty<Integer> MIN_BRANCH_GAP = ConfigurationProperty.integer((String)"min_branch_gap");
    public static final ConfigurationProperty<Integer> MAX_BRANCH_GAP = ConfigurationProperty.integer((String)"max_branch_gap");
    public static final ConfigurationProperty<Integer> BRANCH_HEIGHT_VARIATION = ConfigurationProperty.integer((String)"branch_height_variation");
    public static final ConfigurationProperty<Integer> SIDE_BRANCH_ENERGY = ConfigurationProperty.integer((String)"side_branch_energy");

    public AncientLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(MIN_BRANCH_GAP, (Object)4)).with(MAX_BRANCH_GAP, (Object)6)).with(BRANCH_HEIGHT_VARIATION, (Object)3)).with(HEIGHT_VARIATION, (Object)10)).with(SIDE_BRANCH_ENERGY, (Object)4);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{MIN_BRANCH_GAP, MAX_BRANCH_GAP, BRANCH_HEIGHT_VARIATION, HEIGHT_VARIATION, SIDE_BRANCH_ENERGY});
    }

    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        Direction newDir = super.selectNewDirection(configuration, context);
        GrowSignal signal = context.signal();
        if (signal.isInTrunk() && newDir != Direction.UP) {
            signal.energy = Math.min((float)((Integer)configuration.get(SIDE_BRANCH_ENERGY)).intValue(), signal.energy);
        }
        return newDir;
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = super.populateDirectionProbabilityMap(configuration, context);
        GrowSignal signal = context.signal();
        Direction travelDir = signal.dir;
        if (signal.isInTrunk()) {
            int minGap = (Integer)configuration.get(MIN_BRANCH_GAP);
            int maxGap = (Integer)configuration.get(MAX_BRANCH_GAP);
            int gap = minGap + CoordUtils.coordHashCode((BlockPos)signal.rootPos, (int)0) % (maxGap - minGap + 1);
            probMap[5] = (int)signal.energy % gap == 0 ? 3 : 0;
            probMap[4] = probMap[5];
            probMap[3] = probMap[5];
            probMap[2] = probMap[5];
        } else {
            int deltaZAbs;
            probMap[1] = 0;
            probMap[0] = 0;
            int deltaXAbs = Math.abs(signal.delta.m_123341_());
            if (deltaXAbs == 1 ^ (deltaZAbs = Math.abs(signal.delta.m_123343_())) == 1) {
                probMap[5] = 0;
                probMap[4] = 0;
                probMap[3] = 0;
                probMap[2] = 0;
                probMap[travelDir.ordinal()] = 2;
            }
        }
        probMap[Direction.DOWN.m_122411_()] = 0;
        probMap[travelDir.m_122424_().ordinal()] = 0;
        return probMap;
    }

    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return super.getEnergy(configuration, context) * context.species().biomeSuitability(context.level(), context.pos()) + this.getHashVariation(configuration, context);
    }

    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return (int)((float)super.getLowestBranchHeight(configuration, context) + this.getHashVariation(configuration, context) % (float)((Integer)configuration.get(BRANCH_HEIGHT_VARIATION)).intValue());
    }

    protected float getHashVariation(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        long day = context.level().m_46467_() / 24000L;
        int month = (int)day / 30;
        return CoordUtils.coordHashCode((BlockPos)context.pos().m_6630_(month), (int)2) % (Integer)configuration.get(HEIGHT_VARIATION);
    }
}

