/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.questkilltask.mixin;

import dev.architectury.event.EventResult;
import dev.ftb.mods.ftbquests.FTBQuestsEventHandler;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.muon.questkilltask.DamageTracker;
import dev.muon.questkilltask.QuestKillTask;
import dev.muon.questkilltask.QuestProcessor;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FTBQuestsEventHandler.class}, remap=false)
public class FTBQuestsEventHandlerMixin {
    @Unique
    private QuestProcessor questKillTask$questProcessor;

    @Inject(method={"playerKill"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPlayerKill(LivingEntity entity, DamageSource source, CallbackInfoReturnable<EventResult> cir) {
        if (entity.m_9236_().f_46443_ || source.m_7639_() != null && source.m_7639_().m_9236_().f_46443_) {
            return;
        }
        if (this.questKillTask$questProcessor == null) {
            this.questKillTask$questProcessor = new QuestProcessor();
        }
        if (!this.questKillTask$questProcessor.shouldProcessKill(entity)) {
            cir.setReturnValue((Object)EventResult.pass());
            return;
        }
        ServerQuestFile questFile = this.questKillTask$questProcessor.getQuestFile();
        if (questFile == null) {
            QuestKillTask.LOG.warn("Unable to retrieve Server Quest File!");
            cir.setReturnValue((Object)EventResult.pass());
            return;
        }
        this.questKillTask$questProcessor.processDamagingTeams(entity, questFile);
        DamageTracker.clearEntityTracking(entity);
        cir.setReturnValue((Object)EventResult.pass());
    }
}

