/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.model.entity;

import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoBone;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoModel;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.cache.object.GeoBone;

@OnlyIn(value=Dist.CLIENT)
public class ModelGeckoBiped
extends MowzieGeoModel<GeckoPlayer> {
    private ResourceLocation textureLocation;
    public boolean isSitting = false;
    public boolean isChild = true;
    public float swingProgress;
    public boolean isSneak;
    public float swimAnimation;
    public HumanoidModel.ArmPose leftArmPose = HumanoidModel.ArmPose.EMPTY;
    public HumanoidModel.ArmPose rightArmPose = HumanoidModel.ArmPose.EMPTY;
    protected boolean useSmallArms = false;

    public ResourceLocation getAnimationResource(GeckoPlayer animatable) {
        return new ResourceLocation("mowziesmobs", "animations/animated_player.animation.json");
    }

    public ResourceLocation getModelResource(GeckoPlayer animatable) {
        return new ResourceLocation("mowziesmobs", "geo/animated_player.geo.json");
    }

    public ResourceLocation getTextureResource(GeckoPlayer animatable) {
        return this.textureLocation;
    }

    public void setTextureFromPlayer(AbstractClientPlayer player) {
        this.textureLocation = player.m_108560_();
    }

    public void setUseSmallArms(boolean useSmallArms) {
        this.useSmallArms = useSmallArms;
    }

    public boolean isUsingSmallArms() {
        return this.useSmallArms;
    }

    public MowzieGeoBone bipedHead() {
        return this.getMowzieBone("Head");
    }

    public MowzieGeoBone bipedHeadwear() {
        return this.getMowzieBone("HatLayer");
    }

    public MowzieGeoBone bipedBody() {
        return this.getMowzieBone("Body");
    }

    public MowzieGeoBone bipedRightArm() {
        return this.getMowzieBone("RightArm");
    }

    public MowzieGeoBone bipedLeftArm() {
        return this.getMowzieBone("LeftArm");
    }

    public MowzieGeoBone bipedRightLeg() {
        return this.getMowzieBone("RightLeg");
    }

    public MowzieGeoBone bipedLeftLeg() {
        return this.getMowzieBone("LeftLeg");
    }

    public void setVisible(boolean visible) {
        this.bipedHead().setHidden(!visible);
        this.bipedHeadwear().setHidden(!visible);
        this.bipedBody().setHidden(!visible);
        this.bipedRightArm().setHidden(!visible);
        this.bipedLeftArm().setHidden(!visible);
        this.bipedRightLeg().setHidden(!visible);
        this.bipedLeftLeg().setHidden(!visible);
    }

    public void setRotationAngles() {
        MowzieGeoBone head = this.getMowzieBone("Head");
        MowzieGeoBone neck = this.getMowzieBone("Neck");
        float yaw = 0.0f;
        float pitch = 0.0f;
        float roll = 0.0f;
        for (MowzieGeoBone parent = neck.getParent(); parent != null; parent = parent.getParent()) {
            pitch += parent.getRotX();
            yaw += parent.getRotY();
            roll += parent.getRotZ();
        }
        neck.addRot(-yaw, -pitch, -roll);
    }

    public void setRotationAngles(Player entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float partialTick) {
        boolean flag3;
        if (!this.isInitialized()) {
            return;
        }
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        MowzieGeoBone rightArmClassic = this.getMowzieBone("RightArmClassic");
        MowzieGeoBone leftArmClassic = this.getMowzieBone("LeftArmClassic");
        MowzieGeoBone rightArmSlim = this.getMowzieBone("RightArmSlim");
        MowzieGeoBone leftArmSlim = this.getMowzieBone("LeftArmSlim");
        if (this.useSmallArms) {
            rightArmClassic.setHidden(true);
            leftArmClassic.setHidden(true);
            rightArmSlim.setHidden(false);
            leftArmSlim.setHidden(false);
        } else {
            rightArmSlim.setHidden(true);
            leftArmSlim.setHidden(true);
            rightArmClassic.setHidden(false);
            leftArmClassic.setHidden(false);
        }
        this.swimAnimation = entityIn.m_20998_(partialTick);
        float headLookAmount = this.getControllerValueInverted("HeadLookController");
        float armLookAmount = 1.0f - this.getControllerValueInverted("ArmPitchController");
        float armLookAmountRight = ((GeoBone)this.getBone("ArmPitchController").get()).getPosY();
        float armLookAmountLeft = ((GeoBone)this.getBone("ArmPitchController").get()).getPosZ();
        boolean flag = entityIn.m_21256_() > 4;
        boolean flag1 = entityIn.m_6067_();
        this.bipedHead().addRotY(headLookAmount * -netHeadYaw * ((float)Math.PI / 180));
        this.getMowzieBone("LeftClavicle").addRotY(Math.min(armLookAmount + armLookAmountLeft, 1.0f) * -netHeadYaw * ((float)Math.PI / 180));
        this.getMowzieBone("RightClavicle").addRotY(Math.min(armLookAmount + armLookAmountRight, 1.0f) * -netHeadYaw * ((float)Math.PI / 180));
        if (flag) {
            this.bipedHead().addRotX(-0.7853982f);
        } else if (this.swimAnimation > 0.0f) {
            if (flag1) {
                this.bipedHead().addRotX(headLookAmount * this.rotLerpRad(this.swimAnimation, this.bipedHead().getRotX(), -0.7853982f));
            } else {
                this.bipedHead().addRotX(headLookAmount * this.rotLerpRad(this.swimAnimation, this.bipedHead().getRotX(), headPitch * ((float)Math.PI / 180)));
            }
        } else {
            this.bipedHead().addRotX(headLookAmount * -headPitch * ((float)Math.PI / 180));
            this.getMowzieBone("LeftClavicle").addRotX(Math.min(armLookAmount + armLookAmountLeft, 1.0f) * -headPitch * ((float)Math.PI / 180));
            this.getMowzieBone("RightClavicle").addRotX(Math.min(armLookAmount + armLookAmountRight, 1.0f) * -headPitch * ((float)Math.PI / 180));
        }
        float f = 1.0f;
        if (flag) {
            f = (float)entityIn.m_20184_().m_82556_();
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        float legWalkAmount = this.getControllerValueInverted("LegWalkController");
        float armSwingAmount = this.getControllerValueInverted("ArmSwingController");
        float armSwingAmountRight = 1.0f - ((GeoBone)this.getBone("ArmSwingController").get()).getPosY();
        float armSwingAmountLeft = 1.0f - ((GeoBone)this.getBone("ArmSwingController").get()).getPosZ();
        this.bipedRightArm().addRotX(armSwingAmount * armSwingAmountRight * Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f);
        this.bipedLeftArm().addRotX(armSwingAmount * armSwingAmountLeft * Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f);
        this.bipedRightLeg().addRotX(legWalkAmount * Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / f);
        this.bipedLeftLeg().addRotX(legWalkAmount * Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / f);
        if (this.isSitting) {
            this.bipedRightArm().setRotX(this.bipedRightArm().getRotX() + -0.62831855f);
            this.bipedLeftArm().setRotX(this.bipedRightArm().getRotX() + -0.62831855f);
            this.bipedRightLeg().setRotX(-1.4137167f);
            this.bipedRightLeg().setRotY(0.31415927f);
            this.bipedRightLeg().setRotZ(0.07853982f);
            this.bipedLeftLeg().setRotX(-1.4137167f);
            this.bipedLeftLeg().setRotY(-0.31415927f);
            this.bipedLeftLeg().setRotZ(-0.07853982f);
            this.getMowzieBone("Waist").setRot(0.0f, 0.0f, 0.0f);
            this.getMowzieBone("Root").setRot(0.0f, 0.0f, 0.0f);
        }
        boolean flag2 = entityIn.m_5737_() == HumanoidArm.RIGHT;
        boolean bl = flag3 = flag2 ? this.leftArmPose.m_102897_() : this.rightArmPose.m_102897_();
        if (flag2 != flag3) {
            this.poseLeftArm(entityIn);
            this.poseRightArm(entityIn);
        } else {
            this.poseRightArm(entityIn);
            this.poseLeftArm(entityIn);
        }
        float sneakController = this.getControllerValueInverted("CrouchController");
        if (this.isSneak) {
            this.bipedBody().addRotX(-0.5f * sneakController);
            this.getMowzieBone("Neck").addRotX(0.5f * sneakController);
            this.bipedRightArm().addRot(0.4f * sneakController, 0.0f, 0.0f);
            this.bipedLeftArm().addRot(0.4f * sneakController, 0.0f, 0.0f);
            this.bipedHead().addPosY(-1.0f * sneakController);
            this.bipedBody().addPos(0.0f, -1.5f * sneakController, 1.7f * sneakController);
            this.getMowzieBone("Waist").addPos(0.0f, -0.2f * sneakController, 4.0f * sneakController);
            this.bipedLeftArm().addRotX(-0.4f * sneakController);
            this.bipedLeftArm().addPos(0.0f, 0.2f * sneakController, -1.0f * sneakController);
            this.bipedRightArm().addRotX(-0.4f * sneakController);
            this.bipedRightArm().addPos(0.0f, 0.2f * sneakController, -1.0f * sneakController);
            this.getMowzieBone("Waist").addPosY(2.0f * (1.0f - sneakController));
        }
        float armBreathAmount = this.getControllerValueInverted("ArmBreathController");
        ModelGeckoBiped.breathAnim(this.bipedRightArm(), this.bipedLeftArm(), ageInTicks, armBreathAmount);
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)entityIn);
        if (abilityCapability != null && abilityCapability.getActiveAbility() != null) {
            abilityCapability.codeAnimations(this, partialTick);
        }
    }

    protected MowzieGeoBone getArmForSide(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.bipedLeftArm() : this.bipedRightArm();
    }

    protected float rotLerpRad(float angleIn, float maxAngleIn, float mulIn) {
        float f = (mulIn - maxAngleIn) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return maxAngleIn + angleIn * f;
    }

    private float getArmAngleSq(float limbSwing) {
        return -65.0f * limbSwing + limbSwing * limbSwing;
    }

    protected HumanoidArm getMainHand(Player entityIn) {
        HumanoidArm handside = entityIn.m_5737_();
        return entityIn.f_20912_ == InteractionHand.MAIN_HAND ? handside : handside.m_20828_();
    }

    public static void breathAnim(MowzieGeoBone rightArm, MowzieGeoBone leftArm, float ageInTicks, float armBreathAmount) {
        rightArm.addRotZ(armBreathAmount * Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f);
        leftArm.addRotZ(armBreathAmount * -Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f - 0.05f);
        rightArm.addRotX(armBreathAmount * Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f);
        leftArm.addRotX(armBreathAmount * -Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f);
    }

    private void poseRightArm(Player p_241654_1_) {
        float armSwingAmount = this.getControllerValueInverted("ArmSwingController");
        switch (this.rightArmPose) {
            case EMPTY: {
                break;
            }
            case BLOCK: {
                this.bipedRightArm().addRotX(0.9424779f * armSwingAmount);
                break;
            }
            case ITEM: {
                this.bipedRightArm().addRotX(0.31415927f * armSwingAmount);
            }
        }
    }

    private void poseLeftArm(Player p_241655_1_) {
        float armSwingAmount = this.getControllerValueInverted("ArmSwingController");
        switch (this.leftArmPose) {
            case EMPTY: {
                break;
            }
            case BLOCK: {
                this.bipedLeftArm().addRotX(0.9424779f * armSwingAmount);
                break;
            }
            case ITEM: {
                this.bipedLeftArm().addRotX(0.31415927f * armSwingAmount);
            }
        }
    }
}

