/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle;

import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import com.bobmowzie.mowziesmobs.client.particle.util.TerrainParticleData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;

public class AdvancedTerrainParticle
extends AdvancedParticleBase {
    private final BlockPos pos;
    private final float uo;
    private final float vo;

    protected AdvancedTerrainParticle(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double motionX, double motionY, double motionZ, double scale, double drag, double duration, boolean canCollide, BlockState state, BlockPos pos, ParticleComponent[] components) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, motionX, motionY, motionZ, new ParticleRotation.FaceCamera(0.0f), scale, 1.0, 1.0, 1.0, 1.0, drag, duration, false, canCollide, components);
        this.pos = pos;
        this.m_108337_(Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(state));
        this.red = 0.6f;
        this.green = 0.6f;
        this.blue = 0.6f;
        if (IClientBlockExtensions.of((BlockState)state).areBreakingParticlesTinted(state, this.getLevel(), pos)) {
            int i = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)this.getLevel(), pos, 0);
            this.red *= (float)(i >> 16 & 0xFF) / 255.0f;
            this.green *= (float)(i >> 8 & 0xFF) / 255.0f;
            this.blue *= (float)(i & 0xFF) / 255.0f;
        }
        this.f_107663_ /= 2.0f;
        this.uo = this.f_107223_.m_188501_() * 3.0f;
        this.vo = this.f_107223_.m_188501_() * 3.0f;
    }

    public Particle updateSprite(BlockState state, BlockPos pos) {
        if (pos != null) {
            this.m_108337_(Minecraft.m_91087_().m_91289_().m_110907_().getTexture(state, (Level)this.f_107208_, pos));
        }
        return this;
    }

    @Override
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107429_;
    }

    protected float m_5970_() {
        return this.f_108321_.m_118367_((double)((this.uo + 1.0f) / 4.0f * 16.0f));
    }

    protected float m_5952_() {
        return this.f_108321_.m_118367_((double)(this.uo / 4.0f * 16.0f));
    }

    protected float m_5951_() {
        return this.f_108321_.m_118393_((double)(this.vo / 4.0f * 16.0f));
    }

    protected float m_5950_() {
        return this.f_108321_.m_118393_((double)((this.vo + 1.0f) / 4.0f * 16.0f));
    }

    @Override
    public int m_6355_(float p_108291_) {
        int i = super.m_6355_(p_108291_);
        return i == 0 && this.f_107208_.m_46805_(this.pos) ? LevelRenderer.m_109541_((BlockAndTintGetter)this.f_107208_, (BlockPos)this.pos) : i;
    }

    public static void spawnTerrainParticle(Level world, ParticleType<TerrainParticleData> particle, double x, double y, double z, double motionX, double motionY, double motionZ, double rotation, double scale, double drag, double duration, BlockState state, ParticleComponent[] components) {
        world.m_7106_((ParticleOptions)new TerrainParticleData(particle, rotation, scale, drag, duration, state, components), x, y, z, motionX, motionY, motionZ);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<TerrainParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(TerrainParticleData typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BlockState blockstate = typeIn.getState();
            if (blockstate.m_60795_() || blockstate.m_60713_(Blocks.f_50110_)) {
                return null;
            }
            AdvancedTerrainParticle particle = new AdvancedTerrainParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getScale(), typeIn.getAirDrag(), typeIn.getDuration(), typeIn.getCanCollide(), typeIn.getState(), BlockPos.f_121853_, typeIn.getComponents());
            particle.m_107253_((float)typeIn.getRed(), (float)typeIn.getGreen(), (float)typeIn.getBlue());
            particle.updateSprite(blockstate, typeIn.getPos());
            return particle;
        }
    }
}

