/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.create_better_villagers.init;

import com.google.common.collect.ImmutableSet;
import com.reggarf.mods.create_better_villagers.CreateBetterVillagersMod;
import com.simibubi.create.AllBlocks;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CreateBetterVillagersModVillagerProfessions {
    private static final Map<String, ProfessionPoiType> POI_TYPES = new HashMap<String, ProfessionPoiType>();
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"create_better_villagers");
    public static final RegistryObject<VillagerProfession> ANDESITE_WORKER = CreateBetterVillagersModVillagerProfessions.registerProfession("andesite_worker", () -> ((BlockEntry)AllBlocks.BASIN).get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.anvil.use")));
    public static final RegistryObject<VillagerProfession> BRASSWORKER = CreateBetterVillagersModVillagerProfessions.registerProfession("brassworker", () -> ((BlockEntry)AllBlocks.ROTATION_SPEED_CONTROLLER).get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.comparator.click")));
    public static final RegistryObject<VillagerProfession> COPPERWORKER = CreateBetterVillagersModVillagerProfessions.registerProfession("copperworker", () -> ((BlockEntry)AllBlocks.STEAM_ENGINE).get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.copper.place")));
    public static final RegistryObject<VillagerProfession> MINER = CreateBetterVillagersModVillagerProfessions.registerProfession("miner", () -> ((BlockEntry)AllBlocks.MECHANICAL_ARM).get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.stone.break")));
    public static final RegistryObject<VillagerProfession> BRASS_MINNER = CreateBetterVillagersModVillagerProfessions.registerProfession("brass_minner", () -> ((BlockEntry)AllBlocks.MECHANICAL_HARVESTER).get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.amethyst_block.break")));
    public static final RegistryObject<VillagerProfession> COPPERMINNER = CreateBetterVillagersModVillagerProfessions.registerProfession("copperminner", () -> ((BlockEntry)AllBlocks.HOSE_PULLEY).get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("intentionally_empty")));

    private static RegistryObject<VillagerProfession> registerProfession(String name, Supplier<Block> block, Supplier<SoundEvent> soundEvent) {
        POI_TYPES.put(name, new ProfessionPoiType(block, null));
        return PROFESSIONS.register(name, () -> {
            Predicate<Holder> poiPredicate = poiTypeHolder -> CreateBetterVillagersModVillagerProfessions.POI_TYPES.get((Object)name).poiType != null && poiTypeHolder.get() == CreateBetterVillagersModVillagerProfessions.POI_TYPES.get((Object)name).poiType.get();
            return new VillagerProfession("create_better_villagers:" + name, poiPredicate, poiPredicate, ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)soundEvent.get());
        });
    }

    @SubscribeEvent
    public static void registerProfessionPointsOfInterest(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.POI_TYPES, registerHelper -> {
            for (Map.Entry<String, ProfessionPoiType> entry : POI_TYPES.entrySet()) {
                Block block = entry.getValue().block.get();
                String name = entry.getKey();
                Optional existingCheck = PoiTypes.m_218075_((BlockState)block.m_49966_());
                if (existingCheck.isPresent()) {
                    CreateBetterVillagersMod.LOGGER.error("Skipping villager profession " + name + " that uses POI block " + block + " that is already in use by " + existingCheck);
                    continue;
                }
                PoiType poiType = new PoiType((Set)ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_()), 1, 1);
                registerHelper.register(name, (Object)poiType);
                entry.getValue().poiType = (Holder)ForgeRegistries.POI_TYPES.getHolder((Object)poiType).get();
            }
        });
    }

    private static class ProfessionPoiType {
        final Supplier<Block> block;
        Holder<PoiType> poiType;

        ProfessionPoiType(Supplier<Block> block, Holder<PoiType> poiType) {
            this.block = block;
            this.poiType = poiType;
        }
    }
}

