/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.impl.BlockAccessorImpl;

public class DatapackBlockManager {
    private static final Set<BlockPos> itemFrames = Sets.newConcurrentHashSet();

    public static void onEntityJoin(Entity entity) {
        if (entity.m_6095_() == EntityType.f_20462_ || entity.m_6095_() == EntityType.f_147033_) {
            itemFrames.add(entity.m_20183_());
        }
    }

    public static void onEntityLeave(Entity entity) {
        if (entity.m_6095_() == EntityType.f_20462_ || entity.m_6095_() == EntityType.f_147033_) {
            BlockPos pos = entity.m_20183_();
            DatapackBlockManager.getFakeBlock((LevelAccessor)entity.m_9236_(), pos);
        }
    }

    public static ItemStack getFakeBlock(LevelAccessor level, BlockPos pos) {
        if (itemFrames.contains(pos)) {
            List entities = level.m_6443_(ItemFrame.class, new AABB(pos), $ -> $.m_20145_() && $.m_6084_());
            if (entities.isEmpty()) {
                itemFrames.remove(pos);
            } else {
                ItemStack stack = ((ItemFrame)entities.get(0)).m_31822_();
                if (stack.m_41782_() && stack.m_41783_().m_128441_("storedItem")) {
                    stack = ItemStack.m_41712_((CompoundTag)stack.m_41737_("storedItem"));
                }
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public static Accessor<?> override(HitResult hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        BlockAccessorImpl target;
        if (accessor instanceof BlockAccessorImpl && (target = (BlockAccessorImpl)accessor).getFakeBlock().m_41619_()) {
            target.setFakeBlock(DatapackBlockManager.getFakeBlock((LevelAccessor)target.getLevel(), target.getPosition()));
        }
        return accessor;
    }
}

