/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.create;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageSavedData;

public class MountedStorageData
extends SavedData
implements IStorageSavedData {
    private static final String SAVED_DATA_PREFIX = "sophisticatedcore_mounted/";
    private CompoundTag movingStorageContents = new CompoundTag();
    private boolean toRemove = false;
    private static final Cache<UUID, MountedStorageData> clientStorageCopy = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private final Set<UUID> updatedStorageSettingsFlags = new HashSet<UUID>();

    private MountedStorageData() {
    }

    public static MountedStorageData get(UUID storageId) {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.m_129880_(Level.f_46428_);
            DimensionDataStorage storage = overworld.m_8895_();
            return (MountedStorageData)storage.m_164861_(MountedStorageData::load, MountedStorageData::new, SAVED_DATA_PREFIX + String.valueOf(storageId));
        }
        MountedStorageData storageData = (MountedStorageData)clientStorageCopy.getIfPresent((Object)storageId);
        if (storageData == null) {
            storageData = new MountedStorageData();
            clientStorageCopy.put((Object)storageId, (Object)storageData);
        }
        return storageData;
    }

    public static MountedStorageData load(CompoundTag nbt) {
        MountedStorageData storageData = new MountedStorageData();
        storageData.movingStorageContents = nbt;
        return storageData;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        if (this.movingStorageContents != null) {
            return this.movingStorageContents;
        }
        return new CompoundTag();
    }

    public void removeStorageContents() {
        this.toRemove = true;
        this.m_77762_();
    }

    public void m_77757_(File file) {
        if (this.toRemove) {
            file.delete();
        } else {
            try {
                Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                SophisticatedCore.LOGGER.error("Failed to create directories for moving storage data", (Throwable)e);
            }
            super.m_77757_(file);
        }
    }

    public void setContents(UUID storageUuid, CompoundTag contents) {
        for (String key : contents.m_128431_()) {
            this.movingStorageContents.m_128365_(key, contents.m_128423_(key));
            if (!key.equals("settings")) continue;
            this.updatedStorageSettingsFlags.add(storageUuid);
        }
        this.m_77762_();
    }

    @Override
    public CompoundTag getContents() {
        return this.movingStorageContents;
    }

    @Override
    public void setContents(CompoundTag contents) {
        this.movingStorageContents = contents;
        this.m_77762_();
    }

    @Override
    public void markChanged() {
        this.m_77762_();
    }

    public boolean removeUpdatedStorageSettingsFlag(UUID backpackUuid) {
        return this.updatedStorageSettingsFlags.remove(backpackUuid);
    }
}

