/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.PlayDiscMessage;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.StopDiscPlaybackMessage;

public class ServerStorageSoundHandler {
    private static final int KEEP_ALIVE_CHECK_INTERVAL = 10;
    private static final Map<ResourceKey<Level>, Long> lastWorldCheck = new HashMap<ResourceKey<Level>, Long>();
    private static final Map<ResourceKey<Level>, Map<UUID, KeepAliveInfo>> worldStorageSoundKeepAlive = new HashMap<ResourceKey<Level>, Map<UUID, KeepAliveInfo>>();

    private ServerStorageSoundHandler() {
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(ServerStorageSoundHandler::tick);
    }

    public static void tick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.level.m_5776_()) {
            return;
        }
        ServerLevel world = (ServerLevel)event.level;
        ResourceKey dim = world.m_46472_();
        if (lastWorldCheck.computeIfAbsent((ResourceKey<Level>)dim, key -> world.m_46467_()) > world.m_46467_() - 10L || !worldStorageSoundKeepAlive.containsKey(dim)) {
            return;
        }
        lastWorldCheck.put((ResourceKey<Level>)dim, world.m_46467_());
        worldStorageSoundKeepAlive.get(dim).entrySet().removeIf(entry -> {
            if (((KeepAliveInfo)entry.getValue()).getLastKeepAliveTime() < world.m_46467_() - 10L) {
                ServerStorageSoundHandler.sendStopMessage(world, ((KeepAliveInfo)entry.getValue()).getLastPosition(), (UUID)entry.getKey());
                return true;
            }
            return false;
        });
    }

    public static void updateKeepAlive(UUID storageUuid, Level world, Vec3 position, Runnable onNoLongerRunning) {
        ResourceKey dim = world.m_46472_();
        if (!worldStorageSoundKeepAlive.containsKey(dim) || !worldStorageSoundKeepAlive.get(dim).containsKey(storageUuid)) {
            onNoLongerRunning.run();
            return;
        }
        if (worldStorageSoundKeepAlive.get(dim).containsKey(storageUuid)) {
            worldStorageSoundKeepAlive.get(dim).get(storageUuid).update(world.m_46467_(), position);
        }
    }

    public static void onSoundFinished(ServerLevel level, UUID storageUuid) {
        ServerStorageSoundHandler.removeKeepAliveInfo(level, storageUuid, true);
    }

    public static void startPlayingDisc(ServerLevel serverWorld, BlockPos position, UUID storageUuid, int discItemId, Runnable onFinishedHandler) {
        Vec3 pos = Vec3.m_82512_((Vec3i)position);
        PacketHandler.INSTANCE.sendToAllNear(serverWorld, (ResourceKey<Level>)serverWorld.m_46472_(), pos, 128, new PlayDiscMessage(storageUuid, discItemId, position));
        ServerStorageSoundHandler.putKeepAliveInfo(serverWorld, storageUuid, onFinishedHandler, pos);
    }

    public static void startPlayingDisc(ServerLevel serverWorld, Vec3 position, UUID storageUuid, int entityId, int discItemId, Runnable onFinishedHandler) {
        PacketHandler.INSTANCE.sendToAllNear(serverWorld, (ResourceKey<Level>)serverWorld.m_46472_(), position, 128, new PlayDiscMessage(storageUuid, discItemId, entityId));
        ServerStorageSoundHandler.putKeepAliveInfo(serverWorld, storageUuid, onFinishedHandler, position);
    }

    private static void putKeepAliveInfo(ServerLevel serverWorld, UUID storageUuid, Runnable onFinishedHandler, Vec3 pos) {
        worldStorageSoundKeepAlive.computeIfAbsent((ResourceKey<Level>)serverWorld.m_46472_(), dim -> new HashMap()).put(storageUuid, new KeepAliveInfo(onFinishedHandler, serverWorld.m_46467_(), pos));
    }

    public static void stopPlayingDisc(ServerLevel serverWorld, Vec3 position, UUID storageUuid) {
        ServerStorageSoundHandler.removeKeepAliveInfo(serverWorld, storageUuid, false);
        ServerStorageSoundHandler.sendStopMessage(serverWorld, position, storageUuid);
    }

    private static void removeKeepAliveInfo(ServerLevel serverWorld, UUID storageUuid, boolean finished) {
        ResourceKey dim = serverWorld.m_46472_();
        if (worldStorageSoundKeepAlive.containsKey(dim) && worldStorageSoundKeepAlive.get(dim).containsKey(storageUuid)) {
            KeepAliveInfo keepAliveInfo = worldStorageSoundKeepAlive.get(dim).remove(storageUuid);
            if (finished) {
                keepAliveInfo.runOnFinished();
            }
        }
    }

    private static void sendStopMessage(ServerLevel serverWorld, Vec3 position, UUID storageUuid) {
        PacketHandler.INSTANCE.sendToAllNear(serverWorld, (ResourceKey<Level>)serverWorld.m_46472_(), position, 128, new StopDiscPlaybackMessage(storageUuid));
    }

    private static class KeepAliveInfo {
        private final WeakReference<Runnable> onFinishedHandler;
        private long lastKeepAliveTime;
        private Vec3 lastPosition;

        private KeepAliveInfo(Runnable onFinishedHandler, long lastKeepAliveTime, Vec3 lastPosition) {
            this.onFinishedHandler = new WeakReference<Runnable>(onFinishedHandler);
            this.lastKeepAliveTime = lastKeepAliveTime;
            this.lastPosition = lastPosition;
        }

        public long getLastKeepAliveTime() {
            return this.lastKeepAliveTime;
        }

        public Vec3 getLastPosition() {
            return this.lastPosition;
        }

        public void update(long gameTime, Vec3 position) {
            this.lastKeepAliveTime = gameTime;
            this.lastPosition = position;
        }

        public void runOnFinished() {
            Runnable handler = (Runnable)this.onFinishedHandler.get();
            if (handler != null) {
                handler.run();
            }
        }
    }
}

