/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import org.violetmoon.quark.content.building.module.HollowLogsModule;
import org.violetmoon.quark.content.world.module.FallenLogsModule;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.util.MiscUtil;
import org.violetmoon.zeta.world.generator.Generator;

public class FallenLogGenerator
extends Generator {
    public FallenLogGenerator(DimensionConfig dimConfig) {
        super(dimConfig);
    }

    public void generateChunk(WorldGenRegion worldIn, ChunkGenerator generator, RandomSource rand, BlockPos corner) {
        int chance;
        int z;
        int x = corner.m_123341_() + rand.m_188503_(16);
        BlockPos center = new BlockPos(x, 128, z = corner.m_123343_() + rand.m_188503_(16));
        Holder biome = this.getBiome((LevelAccessor)worldIn, center, false);
        int n = chance = biome.m_203656_(FallenLogsModule.reducedLogsTag) ? FallenLogsModule.sparseBiomeRarity : FallenLogsModule.rarity;
        if (rand.m_188503_(chance) == 0) {
            BlockPos pos = worldIn.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, center);
            FallenLogGenerator.placeFallenLogAt((LevelAccessor)worldIn, pos);
        }
    }

    private static void placeFallenLogAt(LevelAccessor level, BlockPos pos) {
        FallenLogGenerator.placeFallenLogAt(level, pos, FallenLogGenerator.getLogBlockForPos(level, pos));
    }

    private static void placeFallenLogAt(LevelAccessor level, BlockPos pos, Block logBlock) {
        if (logBlock == Blocks.f_50016_) {
            return;
        }
        int attempts = 5;
        BlockState state = logBlock.m_49966_();
        RandomSource rand = level.m_213780_();
        for (int attempt = 0; attempt < 5; ++attempt) {
            int dirOrd = rand.m_188503_(MiscUtil.HORIZONTALS.length);
            Direction dir = MiscUtil.HORIZONTALS[dirOrd];
            state = (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)dir.m_122434_());
            int len = 3 + rand.m_188503_(2);
            if (!FallenLogGenerator.isPositionValid(level, pos, len, dir)) continue;
            FallenLogGenerator.createLog(level, pos, len, dir, state, rand, dirOrd);
            return;
        }
    }

    private static void createLog(LevelAccessor level, BlockPos pos, int len, Direction dir, BlockState state, RandomSource rand, int dirOrd) {
        List<Decor> decor = Decor.get(level, pos);
        for (int i = 0; i < len; ++i) {
            BlockPos abovePos;
            BlockState aboveState;
            BlockPos placePos = pos.m_5484_(dir, i);
            level.m_7731_(placePos, state, 3);
            if (rand.m_188503_(10) < 7 && decor.contains((Object)Decor.MOSS_CARPET) && (aboveState = level.m_8055_(abovePos = placePos.m_7494_())).m_60795_()) {
                level.m_7731_(abovePos, Blocks.f_152543_.m_49966_(), 3);
            }
            Direction[][] sideDirections = new Direction[][]{{Direction.EAST, Direction.WEST}, {Direction.EAST, Direction.WEST}, {Direction.NORTH, Direction.SOUTH}, {Direction.NORTH, Direction.SOUTH}};
            for (int j = 0; j < 2; ++j) {
                if (rand.m_188503_(5) >= 3) continue;
                Direction side = sideDirections[dirOrd][j];
                BlockPos sidePos = placePos.m_121945_(side);
                FallenLogGenerator.placeDecorIfPossible(level, rand, side, sidePos, decor);
            }
            if (rand.m_188503_(10) < 4) {
                FallenLogGenerator.placeDecorIfPossible(level, rand, dir, pos.m_121945_(dir.m_122424_()), decor);
            }
            if (rand.m_188503_(10) >= 4) continue;
            FallenLogGenerator.placeDecorIfPossible(level, rand, dir.m_122424_(), pos.m_5484_(dir, len), decor);
        }
    }

    private static boolean isPositionValid(LevelAccessor level, BlockPos pos, int len, Direction dir) {
        boolean canSpawnOnWater = (double)level.m_213780_().m_188501_() < FallenLogsModule.onWaterChance;
        for (int i = 0; i < len; ++i) {
            BlockPos testPos = pos.m_5484_(dir, i);
            BlockState testState = level.m_8055_(testPos);
            if (!(testState.m_60795_() || testState.m_247087_() || testState.m_204336_(BlockTags.f_13041_))) {
                return false;
            }
            BlockPos belowPos = testPos.m_7495_();
            BlockState belowState = level.m_8055_(belowPos);
            if (canSpawnOnWater && belowState.m_60713_(Blocks.f_49990_) || belowState.m_204336_(FallenLogsModule.canSpawnOnTag)) continue;
            return false;
        }
        return true;
    }

    private static void placeDecorIfPossible(LevelAccessor level, RandomSource rand, Direction side, BlockPos sidePos, List<Decor> decor) {
        if (decor.isEmpty()) {
            return;
        }
        BlockState sideState = level.m_8055_(sidePos);
        if (sideState.m_60795_()) {
            BlockState placeState;
            Decor selected = decor.get(rand.m_188503_(decor.size()));
            switch (selected) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case MOSS_CARPET: {
                    BlockState blockState = Blocks.f_152543_.m_49966_();
                    break;
                }
                case VINE: {
                    BlockState blockState = (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.m_57883_((Direction)side.m_122424_()), (Comparable)Boolean.valueOf(true));
                    break;
                }
                case FERN: {
                    BlockState blockState = placeState = Blocks.f_50035_.m_49966_();
                }
            }
            if (placeState.m_60710_((LevelReader)level, sidePos) && (selected != Decor.MOSS_CARPET || level.m_8055_(sidePos.m_7495_()).m_280296_())) {
                level.m_7731_(sidePos, placeState, 3);
            }
        }
    }

    private static Block getLogBlockForPos(LevelAccessor level, BlockPos pos) {
        Block hollow;
        Block base = FallenLogGenerator.getBaseLogBlockForPos(level, pos);
        if (HollowLogsModule.staticEnabled && (double)level.m_213780_().m_188501_() < FallenLogsModule.hollowChance && (hollow = HollowLogsModule.logMap.get(base)) != null) {
            return hollow;
        }
        return base;
    }

    private static Block getBaseLogBlockForPos(LevelAccessor level, BlockPos pos) {
        Holder biome = level.m_204166_(pos);
        ArrayList<Block> matched = new ArrayList<Block>();
        for (Map.Entry<TagKey<Biome>, Block> e : FallenLogsModule.blocksPerTag.entrySet()) {
            if (!biome.m_203656_(e.getKey())) continue;
            matched.add(e.getValue());
        }
        if (matched.isEmpty()) {
            return Blocks.f_50016_;
        }
        return (Block)matched.get(level.m_213780_().m_188503_(matched.size()));
    }

    private static enum Decor {
        MOSS_CARPET,
        VINE,
        FERN;


        public static List<Decor> get(LevelAccessor level, BlockPos pos) {
            Holder b = level.m_204166_(pos);
            Biome biome = (Biome)b.m_203334_();
            ArrayList<Decor> list = new ArrayList<Decor>();
            Biome.ClimateSettings climateSettings = biome.getModifiedClimateSettings();
            double temperature = Mth.m_14036_((float)climateSettings.f_47681_(), (float)0.0f, (float)1.0f);
            double humidify = Mth.m_14036_((float)climateSettings.f_47683_(), (float)0.0f, (float)1.0f);
            humidify *= temperature;
            if (temperature < 0.3) {
                list.add(FERN);
            }
            if (humidify > 0.5) {
                list.add(MOSS_CARPET);
            }
            if (humidify > 0.75) {
                list.add(VINE);
            }
            return list.stream().toList();
        }
    }
}

