/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.belt_grinder;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.drill.DrillBlock;
import com.simibubi.create.foundation.block.IBE;
import fr.lucreeper74.createmetallurgy.content.blocks.belt_grinder.BeltGrinderBlockEntity;
import fr.lucreeper74.createmetallurgy.registries.CMBlockEntityTypes;
import fr.lucreeper74.createmetallurgy.registries.CMDamageTypes;
import java.util.Iterator;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BeltGrinderBlock
extends HorizontalKineticBlock
implements IBE<BeltGrinderBlockEntity> {
    public BeltGrinderBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.CASING_14PX.get(Direction.UP);
    }

    public Class<BeltGrinderBlockEntity> getBlockEntityClass() {
        return BeltGrinderBlockEntity.class;
    }

    public BlockEntityType<? extends BeltGrinderBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CMBlockEntityTypes.BELT_GRINDER.get();
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult ray) {
        if (player.m_5833_() || !player.m_21120_(handIn).m_41619_()) {
            return InteractionResult.PASS;
        }
        if (ray.m_82434_() != Direction.UP) {
            return InteractionResult.PASS;
        }
        return this.onBlockEntityUse((BlockGetter)worldIn, pos, be -> {
            for (int i = 0; i < be.inv.getSlots(); ++i) {
                ItemStack heldItemStack = be.inv.getStackInSlot(i);
                if (worldIn.f_46443_ || heldItemStack.m_41619_()) continue;
                player.m_150109_().m_150079_(heldItemStack);
            }
            be.inv.clear();
            be.notifyUpdate();
            return InteractionResult.SUCCESS;
        });
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        Player player;
        if (entityIn instanceof ItemEntity) {
            return;
        }
        if (entityIn instanceof Player && (player = (Player)entityIn).m_7500_()) {
            return;
        }
        if (!new AABB(pos).m_82406_((double)0.1f).m_82381_(entityIn.m_20191_())) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            float speed = Mth.m_14154_((float)be.getSpeed());
            if (be.getSpeed() == 0.0f) {
                return;
            }
            Level level = entityIn.m_9236_();
            Iterator iterator = entityIn.m_6168_().iterator();
            if (iterator.hasNext()) {
                ItemStack armor = (ItemStack)iterator.next();
                if (armor.m_41619_() || !armor.m_41763_() || armor.m_41773_() >= armor.m_41776_()) {
                    entityIn.m_6469_(CMDamageTypes.grinder(level), (float)DrillBlock.getDamage((float)speed));
                }
                if (AnimationTickHolder.getTicks() % Math.round(-10.0f * speed / 32.0f + 90.0f) == 0) {
                    armor.m_220157_(1, entityIn.m_9236_().m_213780_(), null);
                }
                if (!armor.m_41619_()) {
                    float pitch = speed / 256.0f + 0.8f;
                    entityIn.m_5496_(SoundEvents.f_11998_, 0.3f, entityIn.m_9236_().f_46441_.m_188501_() * 0.2f + pitch);
                    RandomSource r = level.m_213780_();
                    Vec3 c = VecHelper.getCenterOf((Vec3i)be.m_58899_());
                    Vec3 v = c.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.25f).m_82542_(1.0, 0.0, 1.0));
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123797_, v.f_82479_, v.f_82480_ + (double)0.4f, v.f_82481_, 0.0, 0.0, 0.0);
                }
                return;
            }
        });
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (entityIn.m_9236_().f_46443_) {
            return;
        }
        BlockPos pos = entityIn.m_20183_();
        this.withBlockEntityDo((BlockGetter)entityIn.m_9236_(), pos, be -> {
            if (be.getSpeed() == 0.0f) {
                return;
            }
            be.insertItem((ItemEntity)entityIn);
        });
    }
}

