/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.casting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.simibubi.create.AllTags;
import java.util.Iterator;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class CastingOutput {
    public static final CastingOutput EMPTY = CastingOutput.fromStack(ItemStack.f_41583_);

    public abstract ItemStack getStack();

    public abstract JsonElement serialize();

    public static CastingOutput fromStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return EMPTY;
        }
        return new StackOutput(stack);
    }

    public static CastingOutput fromTag(TagKey<Item> tag, int count) {
        return new TagOutput(tag, count);
    }

    public static CastingOutput deserialize(JsonElement je) {
        if (!je.isJsonObject()) {
            throw new JsonSyntaxException("CastingOutput must be a json object");
        }
        JsonObject json = je.getAsJsonObject();
        int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
        if (json.has("item")) {
            String itemId = GsonHelper.m_13906_((JsonObject)json, (String)"item");
            ItemStack itemstack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), count);
            return CastingOutput.fromStack(itemstack);
        }
        if (json.has("tag")) {
            String rawTag = GsonHelper.m_13906_((JsonObject)json, (String)"tag");
            TagKey tag = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.ITEMS, (ResourceLocation)new ResourceLocation(rawTag));
            return CastingOutput.fromTag((TagKey<Item>)tag, count);
        }
        throw new JsonParseException("An CastingOutput entry needs either a tag or an item");
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130055_(this.getStack());
    }

    public static CastingOutput read(FriendlyByteBuf buf) {
        return CastingOutput.fromStack(buf.m_130267_());
    }

    private static class StackOutput
    extends CastingOutput {
        private final ItemStack stack;

        private StackOutput(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public ItemStack getStack() {
            return this.stack;
        }

        @Override
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).toString());
            int count = this.stack.m_41613_();
            if (count > 1) {
                json.addProperty("count", (Number)count);
            }
            return json;
        }
    }

    private static class TagOutput
    extends CastingOutput {
        private final TagKey<Item> tag;
        private final int count;

        private TagOutput(TagKey<Item> tag, int count) {
            this.tag = tag;
            this.count = count;
        }

        @Override
        public ItemStack getStack() {
            Iterator items = ForgeRegistries.ITEMS.tags().getTag(this.tag).iterator();
            if (items.hasNext()) {
                return new ItemStack((ItemLike)items.next(), this.count);
            }
            return new ItemStack((ItemLike)Blocks.f_50375_).m_41714_((Component)Component.m_237113_((String)("Empty Tag: " + this.tag.f_203868_())));
        }

        @Override
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("tag", this.tag.f_203868_().toString());
            if (this.count > 1) {
                json.addProperty("count", (Number)this.count);
            }
            return json;
        }
    }
}

