/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.casting.recipe;

import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import fr.lucreeper74.createmetallurgy.CreateMetallurgy;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.CastingBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.recipe.CastingOutput;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.slf4j.Logger;

public abstract class CastingRecipe
implements Recipe<SmartInventory> {
    protected final ResourceLocation id;
    protected FluidIngredient fluidIngredient;
    protected Ingredient ingredient;
    protected int processingDuration;
    protected boolean moldConsumed;
    protected CastingOutput result;

    public CastingRecipe(ResourceLocation id) {
        this.id = id;
        this.ingredient = Ingredient.f_43901_;
        this.fluidIngredient = FluidIngredient.EMPTY;
        this.processingDuration = 0;
        this.moldConsumed = false;
        this.result = CastingOutput.EMPTY;
        this.validate(id);
    }

    private void validate(ResourceLocation recipeTypeId) {
        String messageHeader = "Your custom recipe (" + recipeTypeId + ")";
        Logger logger = CreateMetallurgy.LOGGER;
        if (this.ingredient.m_43947_() && this.moldConsumed) {
            logger.warn(messageHeader + " specified a mold condition. Mold conditions have no impact on this recipe cause there is no mold.");
        }
    }

    public static boolean match(CastingBlockEntity be, Recipe<?> recipe) {
        if (recipe instanceof CastingRecipe) {
            CastingRecipe castingRecipe = (CastingRecipe)recipe;
            FluidStack fluidInBuffer = be.getFluidBuffer();
            ItemStack mold = be.moldInv.getStackInSlot(0);
            Ingredient ingredient = castingRecipe.getIngredient();
            boolean fluidMatches = castingRecipe.getFluidIngredient().test(fluidInBuffer);
            boolean hasMold = !ingredient.m_43947_();
            boolean ingredientMatches = hasMold && ingredient.test(mold);
            return fluidMatches && (!hasMold || ingredientMatches);
        }
        return false;
    }

    public boolean matches(SmartInventory inv, Level level) {
        return false;
    }

    public ItemStack assemble(SmartInventory pContainer, RegistryAccess registryAccess) {
        return null;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.getStack();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public abstract RecipeSerializer<?> m_7707_();

    public RecipeType<?> m_6671_() {
        return this.getTypeInfo().getType();
    }

    public abstract IRecipeTypeInfo getTypeInfo();

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public FluidIngredient getFluidIngredient() {
        return this.fluidIngredient;
    }

    public int getProcessingDuration() {
        return this.processingDuration;
    }

    public boolean isMoldConsumed() {
        return this.moldConsumed;
    }
}

