/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.casting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.data.SimpleDatagenIngredient;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.tterrag.registrate.util.DataIngredient;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.recipe.CastingBasinRecipe;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.recipe.CastingOutput;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.recipe.CastingRecipe;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.recipe.CastingRecipeSerializer;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.recipe.CastingTableRecipe;
import fr.lucreeper74.createmetallurgy.registries.CMRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;

public class CastingRecipeBuilder {
    private CastingRecipe recipe;
    protected List<ICondition> recipeConditions;

    public CastingRecipeBuilder(CMRecipeTypes type, ResourceLocation id) {
        switch (type) {
            case CASTING_IN_TABLE: {
                this.recipe = new CastingTableRecipe(id);
                break;
            }
            case CASTING_IN_BASIN: {
                this.recipe = new CastingBasinRecipe(id);
                break;
            }
            default: {
                throw new IllegalArgumentException("Recipe type '" + type + "' its not a Casting Recipe");
            }
        }
        this.recipeConditions = new ArrayList<ICondition>();
    }

    public CastingRecipeBuilder require(TagKey<Item> tag) {
        return this.require(Ingredient.m_204132_(tag));
    }

    public CastingRecipeBuilder require(ItemLike item) {
        return this.require(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public CastingRecipeBuilder require(Ingredient ingredient) {
        this.recipe.ingredient = ingredient;
        return this;
    }

    public CastingRecipeBuilder require(Mods mod, String id) {
        this.recipe.ingredient = new SimpleDatagenIngredient(mod, id);
        return this;
    }

    public CastingRecipeBuilder require(ResourceLocation ingredient) {
        this.recipe.ingredient = DataIngredient.ingredient(null, (ResourceLocation)ingredient, (ItemPredicate[])new ItemPredicate[0]);
        return this;
    }

    public CastingRecipeBuilder require(Fluid fluid, int amount) {
        return this.require(FluidIngredient.fromFluid((Fluid)fluid, (int)amount));
    }

    public CastingRecipeBuilder require(TagKey<Fluid> fluidTag, int amount) {
        return this.require(FluidIngredient.fromTag(fluidTag, (int)amount));
    }

    public CastingRecipeBuilder require(FluidIngredient ingredient) {
        this.recipe.fluidIngredient = ingredient;
        return this;
    }

    public CastingRecipeBuilder output(ItemLike item) {
        return this.output(item, 1);
    }

    public CastingRecipeBuilder output(ItemLike item, int amount) {
        return this.output(new ItemStack(item, amount));
    }

    public CastingRecipeBuilder output(ItemStack output) {
        return this.output(CastingOutput.fromStack(output));
    }

    public CastingRecipeBuilder output(TagKey<Item> tag) {
        return this.output(tag, 1);
    }

    public CastingRecipeBuilder output(TagKey<Item> tag, int amount) {
        return this.output(CastingOutput.fromTag(tag, amount));
    }

    public CastingRecipeBuilder output(CastingOutput output) {
        this.recipe.result = output;
        return this;
    }

    public CastingRecipeBuilder duration(int ticks) {
        this.recipe.processingDuration = ticks;
        return this;
    }

    public CastingRecipeBuilder withMoldConsumed(boolean condition) {
        this.recipe.moldConsumed = condition;
        return this;
    }

    public CastingRecipeBuilder whenModLoaded(String modid) {
        return this.withCondition((ICondition)new ModLoadedCondition(modid));
    }

    public CastingRecipeBuilder withCondition(ICondition condition) {
        this.recipeConditions.add(condition);
        return this;
    }

    public CastingRecipe build() {
        return this.recipe;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new DataGenResult(this.build(), this.recipeConditions));
    }

    public static class DataGenResult
    implements FinishedRecipe {
        private CastingRecipe recipe;
        private List<ICondition> recipeConditions;
        private ResourceLocation id;
        private CastingRecipeSerializer serializer;

        public DataGenResult(CastingRecipe recipe, List<ICondition> recipeConditions) {
            this.recipe = recipe;
            this.recipeConditions = recipeConditions;
            this.id = new ResourceLocation(recipe.m_6423_().m_135827_(), this.recipe.getTypeInfo().getId().m_135815_() + "/" + recipe.m_6423_().m_135815_());
            this.serializer = (CastingRecipeSerializer)recipe.m_7707_();
        }

        public void m_7917_(JsonObject json) {
            this.serializer.write(json, this.recipe);
            if (this.recipeConditions.isEmpty()) {
                return;
            }
            JsonArray conds = new JsonArray();
            this.recipeConditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            json.add("conditions", (JsonElement)conds);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

