/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.foundry_lids.lid;

import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import fr.lucreeper74.createmetallurgy.content.blocks.foundry_basin.FoundryBasinBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.foundry_basin.FoundryBasinOperatingBE;
import fr.lucreeper74.createmetallurgy.content.blocks.foundry_lids.LidBlock;
import fr.lucreeper74.createmetallurgy.registries.CMRecipeTypes;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class FoundryLidBlockEntity
extends FoundryBasinOperatingBE {
    public int processingTime;
    public boolean running;
    private static final Object MeltingRecipesKey = new Object();

    public FoundryLidBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("MeltingTime", this.processingTime);
        compound.m_128379_("Running", this.running);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.processingTime = compound.m_128451_("MeltingTime");
        this.running = compound.m_128471_("Running");
    }

    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.processingTime = 0;
        this.currentRecipe = null;
        this.running = false;
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> recipe) {
        return recipe.m_6671_() == CMRecipeTypes.MELTING.getType();
    }

    public void tick() {
        super.tick();
        if (!(this.f_58857_.f_46443_ || this.currentRecipe != null && this.processingTime != -1)) {
            this.running = false;
            this.processingTime = -1;
            this.basinChecker.scheduleUpdate();
        }
        if (this.running && this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_ && this.processingTime <= 0) {
                this.processingTime = -1;
                this.applyBasinRecipe();
                this.sendData();
            }
            RandomSource random = RandomSource.m_216327_();
            if (!this.f_58857_.f_46443_ && random.m_188503_(40) == 0) {
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12030_, SoundSource.BLOCKS, 0.25f, 0.65f + random.m_188501_() * 0.1f);
            }
            if (this.f_58857_.f_46443_ && this.processingTime % 2 == 0) {
                this.spawnParticles();
            }
            if (this.processingTime > 0) {
                --this.processingTime;
            }
        }
    }

    protected void spawnParticles() {
        RandomSource r = this.f_58857_.m_213780_();
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        Vec3 v = c.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.125f).m_82542_(1.0, 0.0, 1.0));
        if (r.m_188503_(8) == 0) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, v.f_82479_, v.f_82480_ + 0.45, v.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    protected Optional<BasinBlockEntity> getBasin() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        BlockEntity basinBE = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        if (!(basinBE instanceof FoundryBasinBlockEntity)) {
            return Optional.empty();
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)LidBlock.OPEN)).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of((FoundryBasinBlockEntity)basinBE);
    }

    protected boolean updateBasin() {
        if (this.running) {
            return true;
        }
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return true;
        }
        if (this.getBasin().filter(BasinBlockEntity::canContinueProcessing).isEmpty()) {
            return true;
        }
        List recipes = this.getMatchingRecipes();
        if (recipes.isEmpty()) {
            return true;
        }
        this.currentRecipe = (Recipe)recipes.get(0);
        this.startProcessingBasin();
        this.sendData();
        return true;
    }

    protected boolean isRunning() {
        return this.running;
    }

    public void startProcessingBasin() {
        int n;
        if (this.running && this.processingTime > 0) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        Recipe recipe = this.currentRecipe;
        if (recipe instanceof ProcessingRecipe) {
            ProcessingRecipe processed = (ProcessingRecipe)recipe;
            n = processed.getProcessingDuration();
        } else {
            n = 20;
        }
        this.processingTime = n;
    }

    protected Object getRecipeCacheKey() {
        return MeltingRecipesKey;
    }
}

