/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.foundry_mixer;

import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.foundry_basin.FoundryBasinBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.foundry_basin.FoundryBasinRecipe;
import fr.lucreeper74.createmetallurgy.content.blocks.foundry_lids.glassed_lid.GlassedFoundryLidBlock;
import fr.lucreeper74.createmetallurgy.registries.CMRecipeTypes;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class FoundryMixerBlockEntity
extends MechanicalMixerBlockEntity {
    private static final Object AlloyingRecipesKey = new Object();

    public FoundryMixerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> recipe) {
        return recipe.m_6671_() == CMRecipeTypes.ALLOYING.getType();
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ != null && !this.running && !this.f_58857_.f_46443_) {
            this.basinChecker.scheduleUpdate();
        }
    }

    protected <C extends Container> boolean matchBasinRecipe(Recipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        Optional<BasinBlockEntity> basin = this.getBasin();
        return basin.filter(basinBlockEntity -> FoundryBasinRecipe.match((FoundryBasinBlockEntity)((Object)basinBlockEntity), recipe)).isPresent();
    }

    protected void applyBasinRecipe() {
        if (this.currentRecipe == null) {
            return;
        }
        Optional<BasinBlockEntity> optionalBasin = this.getBasin();
        if (optionalBasin.isEmpty()) {
            return;
        }
        FoundryBasinBlockEntity basin = (FoundryBasinBlockEntity)optionalBasin.get();
        boolean wasEmpty = basin.canContinueProcessing();
        if (!FoundryBasinRecipe.apply(basin, this.currentRecipe)) {
            return;
        }
        this.getProcessedRecipeTrigger().ifPresent(arg_0 -> ((FoundryMixerBlockEntity)this).award(arg_0));
        basin.inputTank.sendDataImmediately();
        if (wasEmpty && this.matchBasinRecipe(this.currentRecipe)) {
            this.continueWithPreviousRecipe();
            this.sendData();
        }
        basin.notifyChangeOfContents();
    }

    protected void spillParticle(ParticleOptions data) {
        float angle = this.f_58857_.f_46441_.m_188501_() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, 0.25);
        offset = VecHelper.rotate((Vec3)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 target = VecHelper.rotate((Vec3)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (Direction.Axis)Direction.Axis.Y).m_82520_(0.0, 0.25, 0.0);
        Vec3 center = offset.m_82549_(VecHelper.getCenterOf((Vec3i)this.f_58858_));
        target = VecHelper.offsetRandomly((Vec3)target.m_82546_(offset), (RandomSource)this.f_58857_.f_46441_, (float)0.0078125f);
        this.f_58857_.m_7106_(data, center.f_82479_, center.f_82480_ - (double)1.65f, center.f_82481_, target.f_82479_, target.f_82480_, target.f_82481_);
    }

    protected Optional<BasinBlockEntity> getBasin() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        BlockEntity basinBE = this.f_58857_.m_7702_(this.f_58858_.m_6625_(2));
        Block top = this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60734_();
        if (!(basinBE instanceof FoundryBasinBlockEntity) || !(top instanceof GlassedFoundryLidBlock)) {
            return Optional.empty();
        }
        if (((Boolean)this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_61143_((Property)GlassedFoundryLidBlock.OPEN)).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of((FoundryBasinBlockEntity)basinBE);
    }

    protected Object getRecipeCacheKey() {
        return AlloyingRecipesKey;
    }
}

