/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.CrucibleBlockEntity;
import fr.lucreeper74.createmetallurgy.registries.CMBlockEntityTypes;
import fr.lucreeper74.createmetallurgy.registries.CMBlocks;
import fr.lucreeper74.createmetallurgy.registries.CMItems;
import fr.lucreeper74.createmetallurgy.registries.CMShapes;
import fr.lucreeper74.createmetallurgy.utils.CMConnectivityHandler;
import fr.lucreeper74.createmetallurgy.utils.CMLang;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CrucibleBlock
extends Block
implements IWrenchable,
IBE<CrucibleBlockEntity> {
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.m_61465_((String)"bottom");
    public static final EnumProperty<Shape> SHAPE = EnumProperty.m_61587_((String)"shape", Shape.class);
    public static final BooleanProperty WINDOW = BooleanProperty.m_61465_((String)"window");
    public static final SoundType SILENCED_BRICKS = new ForgeSoundType(0.1f, 1.5f, () -> SoundEvents.f_144103_, () -> SoundEvents.f_144107_, () -> SoundEvents.f_144106_, () -> SoundEvents.f_144105_, () -> SoundEvents.f_144104_);

    public CrucibleBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)super.m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).m_61124_(SHAPE, (Comparable)((Object)Shape.PLAIN))).m_61124_((Property)WINDOW, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean isLadle(BlockState state) {
        return state.m_60734_() instanceof CrucibleBlock;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.m_60734_() == state.m_60734_()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, CrucibleBlockEntity::updateConnectivity);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TOP, BOTTOM, SHAPE, WINDOW});
    }

    public boolean m_5946_(BlockState pState, Fluid pFluid) {
        return false;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        CrucibleBlockEntity ladle = (CrucibleBlockEntity)((Object)CMConnectivityHandler.partAt(this.getBlockEntityType(), world, pos));
        if (ladle == null) {
            return 0;
        }
        if (ladle.getControllerBE() == null) {
            return 0;
        }
        return ladle.luminosity;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (state.m_61143_(SHAPE) == Shape.INNER) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        level.m_46597_(clickedPos, (BlockState)state.m_61124_((Property)WINDOW, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)WINDOW) == false)));
        level.m_5594_(null, clickedPos, SoundEvents.f_144111_, SoundSource.PLAYERS, 1.0f, 0.2f + RandomSource.m_216327_().m_188501_());
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        CrucibleBlockEntity ladleBE;
        CrucibleBlockEntity cBE;
        BlockPos pos;
        Level world = context.m_43725_();
        BlockEntity blockEntity = world.m_7702_(pos = context.m_8083_());
        if (blockEntity instanceof CrucibleBlockEntity && (cBE = (ladleBE = (CrucibleBlockEntity)blockEntity).getControllerBE()) != null && cBE.foundry.isActive()) {
            world.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.PLAYERS, 0.2f, 1.0f + RandomSource.m_216327_().m_188501_());
            cBE.updateLadleState(false);
            if (!context.m_43723_().m_7500_()) {
                context.m_43723_().m_150109_().m_150079_(new ItemStack((ItemLike)CMItems.FOUNDRY_UNIT.get()));
            }
            return InteractionResult.SUCCESS;
        }
        return super.onSneakWrenched(state, context);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        CrucibleBlockEntity controllerBE;
        Fluid fluid;
        ItemStack heldItem = player.m_21120_(hand);
        boolean onClient = level.f_46443_;
        if (heldItem.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (!player.m_7500_()) {
            return InteractionResult.PASS;
        }
        FluidHelper.FluidExchange exchange = null;
        CrucibleBlockEntity be = (CrucibleBlockEntity)((Object)CMConnectivityHandler.partAt(this.getBlockEntityType(), (BlockGetter)level, pos));
        if (be == null) {
            return InteractionResult.FAIL;
        }
        LazyOptional tankCapability = be.getCapability(ForgeCapabilities.FLUID_HANDLER);
        if (!tankCapability.isPresent()) {
            return InteractionResult.PASS;
        }
        IFluidHandler fluidTank = (IFluidHandler)tankCapability.orElse(null);
        FluidStack prevFluidInTank = fluidTank.getFluidInTank(0).copy();
        if (FluidHelper.tryEmptyItemIntoBE((Level)level, (Player)player, (InteractionHand)hand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
            exchange = FluidHelper.FluidExchange.ITEM_TO_TANK;
        } else if (FluidHelper.tryFillItemFromBE((Level)level, (Player)player, (InteractionHand)hand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
            exchange = FluidHelper.FluidExchange.TANK_TO_ITEM;
        }
        if (exchange == null) {
            if (GenericItemEmptying.canItemBeEmptied((Level)level, (ItemStack)heldItem) || GenericItemFilling.canItemBeFilled((Level)level, (ItemStack)heldItem)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        SoundEvent soundevent = null;
        BlockState fluidState = null;
        FluidStack fluidInTank = tankCapability.map(fh -> fh.getFluidInTank(0)).orElse(FluidStack.EMPTY);
        if (exchange == FluidHelper.FluidExchange.ITEM_TO_TANK) {
            fluid = fluidInTank.getFluid();
            fluidState = fluid.m_76145_().m_76188_();
            soundevent = FluidHelper.getEmptySound((FluidStack)fluidInTank);
        }
        if (exchange == FluidHelper.FluidExchange.TANK_TO_ITEM) {
            fluid = prevFluidInTank.getFluid();
            fluidState = fluid.m_76145_().m_76188_();
            soundevent = FluidHelper.getFillSound((FluidStack)prevFluidInTank);
        }
        if (soundevent != null && !onClient) {
            float pitch = Mth.m_14036_((float)(1.0f - 1.0f * (float)fluidInTank.getAmount() / (float)(CrucibleBlockEntity.getCapacityFactor() * 16)), (float)0.0f, (float)1.0f);
            pitch /= 1.5f;
            pitch += 0.5f;
            level.m_5594_(null, pos, soundevent, SoundSource.BLOCKS, 0.5f, pitch += (level.f_46441_.m_188501_() - 0.5f) / 4.0f);
        }
        if (!fluidInTank.isFluidStackIdentical(prevFluidInTank) && be instanceof CrucibleBlockEntity && (controllerBE = be.getControllerBE()) != null) {
            if (onClient) {
                BlockParticleOption blockParticleData = new BlockParticleOption(ParticleTypes.f_123794_, fluidState);
                float fluidLevel = (float)fluidInTank.getAmount() / (float)fluidTank.getTankCapacity(0);
                boolean reversed = fluidInTank.getFluid().getFluidType().isLighterThanAir();
                if (reversed) {
                    fluidLevel = 1.0f - fluidLevel;
                }
                Vec3 vec = hit.m_82450_();
                vec = new Vec3(vec.f_82479_, (double)((float)controllerBE.m_58899_().m_123342_() + fluidLevel * ((float)controllerBE.getHeight() - 0.5f) + 0.25f), vec.f_82481_);
                Vec3 motion = player.m_20182_().m_82546_(vec).m_82490_((double)0.05f);
                vec = vec.m_82549_(motion);
                level.m_7106_((ParticleOptions)blockParticleData, vec.f_82479_, vec.f_82480_, vec.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                return InteractionResult.SUCCESS;
            }
            controllerBE.sendData();
            controllerBE.m_6596_();
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Boolean bottom = (Boolean)state.m_61143_((Property)BOTTOM);
        Shape shape = (Shape)((Object)state.m_61143_(SHAPE));
        Direction direction = shape.toDirection();
        if (bottom.booleanValue()) {
            return switch (shape) {
                case Shape.NE, Shape.SE, Shape.NW, Shape.SW -> CMShapes.CRUCIBLE_CORNER_BOTTOM.get(direction);
                case Shape.NORTH, Shape.SOUTH, Shape.EAST, Shape.WEST -> CMShapes.CRUCIBLE_WALL_BOTTOM.get(direction);
                case Shape.PLAIN -> CMShapes.CRUCIBLE_SINGLE_BOTTOM;
                default -> CMShapes.CRUCIBLE_BOTTOM;
            };
        }
        return switch (shape) {
            case Shape.NE, Shape.SE, Shape.NW, Shape.SW -> CMShapes.CRUCIBLE_CORNER.get(direction);
            case Shape.NORTH, Shape.SOUTH, Shape.EAST, Shape.WEST -> CMShapes.CRUCIBLE_WALL.get(direction);
            case Shape.PLAIN -> CMShapes.CRUCIBLE_SINGLE;
            default -> Shapes.m_83040_();
        };
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_155947_() && (state.m_60734_() != newState.m_60734_() || !newState.m_155947_())) {
            BlockEntity be = world.m_7702_(pos);
            if (!(be instanceof CrucibleBlockEntity)) {
                return;
            }
            CrucibleBlockEntity ladleBe = (CrucibleBlockEntity)be;
            world.m_46747_(pos);
            CMConnectivityHandler.splitMulti(ladleBe);
        }
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
        if (!CMBlocks.INDUSTRIAL_CRUCIBLE.has(worldIn.m_8055_(entityIn.m_20183_()))) {
            return;
        }
        if (entityIn instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entityIn;
            this.withBlockEntityDo(worldIn, entityIn.m_20183_(), be -> {
                ItemStack insertItem = ItemHandlerHelper.insertItem((IItemHandler)be.getControllerBE().foundry.inputInv, (ItemStack)itemEntity.m_32055_().m_41777_(), (boolean)false);
                if (insertItem.m_41619_()) {
                    itemEntity.m_146870_();
                    return;
                }
                itemEntity.m_32045_(insertItem);
            });
        } else {
            this.withBlockEntityDo(worldIn, entityIn.m_20183_(), be -> {
                CrucibleBlockEntity controller;
                if (be != null && (controller = be.getControllerBE()) != null) {
                    controller.processFallOnEntity(entityIn);
                }
            });
        }
    }

    public Class<CrucibleBlockEntity> getBlockEntityClass() {
        return CrucibleBlockEntity.class;
    }

    public BlockEntityType<? extends CrucibleBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CMBlockEntityTypes.INDUSTRIAL_LADLE.get();
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        boolean x = mirror == Mirror.FRONT_BACK;
        return switch ((Shape)((Object)state.m_61143_(SHAPE))) {
            case Shape.NE -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(x ? Shape.NW : Shape.SE)));
            case Shape.NW -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(x ? Shape.NE : Shape.SW)));
            case Shape.SE -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(x ? Shape.SW : Shape.NE)));
            case Shape.SW -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(x ? Shape.SE : Shape.NW)));
            default -> state;
        };
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        for (int i = 0; i < rotation.ordinal(); ++i) {
            state = this.rotateOnce(state);
        }
        return state;
    }

    private BlockState rotateOnce(BlockState state) {
        return switch ((Shape)((Object)state.m_61143_(SHAPE))) {
            case Shape.NE -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.SE));
            case Shape.NW -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.NE));
            case Shape.SE -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.SW));
            case Shape.SW -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.NW));
            default -> state;
        };
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            CrucibleBlockEntity controller = be.getControllerBE();
            if (controller != null && ((Boolean)state.m_61143_((Property)BOTTOM)).booleanValue()) {
                if (!controller.getTank().isEmpty() && random.m_188503_(200) == 0) {
                    level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12030_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.7f + random.m_188501_() * 0.15f, false);
                }
                if (controller.foundry.getCurrentHeat() > 0 && random.m_188503_(3) == 0) {
                    float radius = (float)controller.getWidth() / 2.0f;
                    Vec3 c = Vec3.m_82528_((Vec3i)controller.m_58899_()).m_82520_((double)radius, (double)((float)controller.getHeight() * controller.getTank().getFillState()), (double)radius);
                    Vec3 v = c.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)random, (float)(radius - 0.25f)).m_82542_(1.0, 0.0, 1.0));
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, v.f_82479_, v.f_82480_ + 0.1875, v.f_82481_, 0.0, 0.0, 0.0);
                }
            }
        });
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().m_128441_("SilenceTankSound")) {
            return SILENCED_BRICKS;
        }
        return soundType;
    }

    public static enum Shape implements StringRepresentable
    {
        PLAIN,
        INNER,
        NW,
        SW,
        NE,
        SE,
        NORTH,
        SOUTH,
        WEST,
        EAST;


        public String m_7912_() {
            return CMLang.asId(this.name());
        }

        public boolean isWall() {
            return this.equals((Object)NORTH) || this.equals((Object)SOUTH) || this.equals((Object)WEST) || this.equals((Object)EAST);
        }

        public boolean isCorner() {
            return this.equals((Object)NW) || this.equals((Object)SW) || this.equals((Object)NE) || this.equals((Object)SE);
        }

        public Direction toDirection() {
            return switch (this) {
                case NE, NORTH -> Direction.NORTH;
                case NW, WEST -> Direction.WEST;
                case SW, SOUTH -> Direction.SOUTH;
                case SE, EAST -> Direction.EAST;
                default -> Direction.DOWN;
            };
        }
    }
}

