/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible;

import com.simibubi.create.AllKeys;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.CreateLang;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.CrucibleBlock;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.FoundryData;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.FoundryTank;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.recipes.EntityMeltingRecipe;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.recipes.FoundryRecipe;
import fr.lucreeper74.createmetallurgy.registries.CMDamageTypes;
import fr.lucreeper74.createmetallurgy.registries.CMRecipeTypes;
import fr.lucreeper74.createmetallurgy.utils.CMConnectivityHandler;
import fr.lucreeper74.createmetallurgy.utils.CMLang;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CrucibleBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IMultiBlockEntityContainer {
    public static final int MAX_SIZE = 5;
    private static final int MAX_HEIGHT = 4;
    private static final int CAPACITY_FACTOR = 1000;
    protected FoundryTank tankInventory;
    protected LazyOptional<IFluidHandler> fluidCapability;
    protected LazyOptional<IItemHandlerModifiable> itemCapability;
    protected boolean updateConnectivity;
    protected boolean updateCapability;
    protected int luminosity;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected int width;
    protected int height;
    public FoundryData foundry = new FoundryData();
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private static final Object EntityMeltingCacheKey = new Object();

    public CrucibleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tankInventory = this.createTank();
        this.foundry.createInventory(this, this.getMaxWidth() * this.getMaxWidth() * this.getMaxHeight());
        this.fluidCapability = LazyOptional.of(() -> this.tankInventory);
        this.itemCapability = LazyOptional.of(() -> this.foundry.inputInv);
        this.updateConnectivity = false;
        this.updateCapability = false;
        this.height = 1;
        this.width = 1;
        this.refreshCapability();
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().m_82363_((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    protected FoundryTank createTank() {
        return new FoundryTank(this, 1000, this::onFluidStackChanged);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        int prevLum = this.luminosity;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.luminosity = compound.m_128451_("Luminosity");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.width = compound.m_128451_("Size");
            this.height = compound.m_128451_("Height");
            this.tankInventory.setCapacity(this.getTotalSize() * 1000);
            this.tankInventory.deserializeNBT(compound.m_128469_("TankContent"));
            this.foundry.inputInv.setFirstLimitedSlot(this.getTotalSize());
            this.foundry.inputInv.deserializeNBT(compound.m_128469_("MeltingInv"));
            if (this.tankInventory.getFillState() > 1.0f) {
                this.tankInventory.drain(-(this.tankInventory.getCapacity() - this.tankInventory.getFillAmount()), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (this.luminosity != prevLum && this.m_58898_()) {
            this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
        }
        this.foundry.read(compound.m_128469_("Ladle"));
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.m_58898_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(1000 * this.getTotalSize());
                this.foundry.inputInv.setFirstLimitedSlot(this.getTotalSize());
            }
            this.invalidateRenderBoundingBox();
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        compound.m_128365_("Ladle", (Tag)this.foundry.write());
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (this.isController()) {
            compound.m_128365_("TankContent", (Tag)this.tankInventory.serializeNBT(new CompoundTag()));
            compound.m_128365_("MeltingInv", (Tag)this.foundry.inputInv.serializeNBT());
            compound.m_128405_("Size", this.width);
            compound.m_128405_("Height", this.height);
        } else {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        compound.m_128405_("Luminosity", this.luminosity);
        super.write(compound, clientPacket);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (!this.fluidCapability.isPresent()) {
            this.refreshCapability();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        CMConnectivityHandler.formMulti(this);
    }

    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateCapability) {
            this.updateCapability = false;
            this.refreshCapability();
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.isController()) {
            this.foundry.tick(this);
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void updateState() {
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    BlockState blockState = this.f_58857_.m_8055_(pos);
                    if (!CrucibleBlock.isLadle(blockState)) continue;
                    CrucibleBlock.Shape shape = CrucibleBlock.Shape.PLAIN;
                    if (this.width == 1) {
                        shape = CrucibleBlock.Shape.PLAIN;
                    }
                    if (this.width != 1) {
                        shape = xOffset == 0 ? (zOffset == 0 ? CrucibleBlock.Shape.NW : (zOffset == this.width - 1 ? CrucibleBlock.Shape.SW : CrucibleBlock.Shape.WEST)) : (xOffset == this.width - 1 ? (zOffset == 0 ? CrucibleBlock.Shape.NE : (zOffset == this.width - 1 ? CrucibleBlock.Shape.SE : CrucibleBlock.Shape.EAST)) : (zOffset == 0 ? CrucibleBlock.Shape.NORTH : (zOffset == this.width - 1 ? CrucibleBlock.Shape.SOUTH : CrucibleBlock.Shape.INNER)));
                    }
                    this.f_58857_.m_7731_(pos, (BlockState)blockState.m_61124_(CrucibleBlock.SHAPE, (Comparable)((Object)shape)), 22);
                    this.f_58857_.m_7726_().m_7827_().m_7174_(pos);
                }
            }
        }
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldFCap = this.fluidCapability;
        this.fluidCapability = LazyOptional.of(this::handlerForFluidCapability);
        oldFCap.invalidate();
        LazyOptional<IItemHandlerModifiable> oldICap = this.itemCapability;
        this.itemCapability = LazyOptional.of(this::handlerForItemCapability);
        oldICap.invalidate();
    }

    private IFluidHandler handlerForFluidCapability() {
        return this.isController() ? this.tankInventory : (this.getControllerBE() != null ? this.getControllerBE().handlerForFluidCapability() : new FluidTank(0));
    }

    private IItemHandlerModifiable handlerForItemCapability() {
        return this.isController() ? this.foundry.inputInv : (this.getControllerBE() != null ? this.getControllerBE().handlerForItemCapability() : new SmartInventory(0, (SyncedBlockEntity)this, 0, false));
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
        FluidType attributes = newFluidStack.getFluid().getFluidType();
        int luminosity = (int)((float)attributes.getLightLevel(newFluidStack) / 1.2f);
        boolean reversed = attributes.isLighterThanAir();
        int maxY = (int)(this.tankInventory.getFillState() * (float)this.height + 1.0f);
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            boolean isBright;
            boolean bl = reversed ? this.height - yOffset <= maxY : (isBright = yOffset < maxY);
            int actualLuminosity = isBright ? luminosity : (luminosity > 0 ? 1 : 0);
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    CrucibleBlockEntity tankAt = (CrucibleBlockEntity)((Object)CMConnectivityHandler.partAt(this.m_58903_(), (BlockGetter)this.f_58857_, pos));
                    if (tankAt == null) continue;
                    this.f_58857_.m_46717_(pos, tankAt.m_58900_().m_60734_());
                    if (tankAt.luminosity == actualLuminosity) continue;
                    tankAt.setLuminosity(actualLuminosity);
                }
            }
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
    }

    protected void setLuminosity(int luminosity) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.luminosity == luminosity) {
            return;
        }
        this.luminosity = luminosity;
        this.sendData();
    }

    public CrucibleBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof CrucibleBlockEntity) {
            return (CrucibleBlockEntity)blockEntity;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity(blocks * 1000);
        this.foundry.inputInv.setFirstLimitedSlot(blocks);
        int overflow = this.tankInventory.getFillAmount() - this.tankInventory.getCapacity();
        if (overflow > 0) {
            this.tankInventory.drain(overflow, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.f_58857_.f_46443_) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    public void updateLadleState(boolean controlled) {
        if (!this.isController()) {
            return;
        }
        this.foundry.setActive(controlled);
        this.notifyUpdate();
    }

    public void setController(BlockPos controller) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    public void removeController(boolean keepContents) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.width = 1;
        this.height = 1;
        BlockState state = this.m_58900_();
        if (CrucibleBlock.isLadle(state)) {
            state = (BlockState)state.m_61124_(CrucibleBlock.SHAPE, (Comparable)((Object)CrucibleBlock.Shape.PLAIN));
            state = (BlockState)state.m_61124_((Property)CrucibleBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_((Property)CrucibleBlock.TOP, (Comparable)Boolean.valueOf(true));
            this.m_58904_().m_7731_(this.f_58858_, state, 22);
        }
        this.m_6596_();
        this.sendData();
    }

    protected void processFallOnEntity(Entity entityIn) {
        boolean isFireImmune;
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        if (!entityIn.m_6084_()) {
            return;
        }
        EntityMeltingRecipe recipe = null;
        Predicate type = RecipeConditions.isOfType((RecipeType[])new RecipeType[]{CMRecipeTypes.ENTITY_MELTING.getType()});
        List<Recipe> recipes = RecipeFinder.get((Object)EntityMeltingCacheKey, (Level)this.f_58857_, (Predicate)type).stream().filter(r -> {
            EntityMeltingRecipe entityRecipe;
            return r instanceof EntityMeltingRecipe && (entityRecipe = (EntityMeltingRecipe)((Object)r)).matches(this, (Recipe<?>)entityRecipe, (EntityType<?>)entityIn.m_6095_()) && FoundryRecipe.isEnoughHeated(this, entityRecipe);
        }).toList();
        if (!recipes.isEmpty()) {
            recipe = (EntityMeltingRecipe)recipes.get(0);
        }
        if (!(isFireImmune = entityIn.m_5825_()) && this.foundry.getCurrentHeat() > 0) {
            entityIn.m_20254_(15);
        }
        if (recipe != null) {
            if (entityIn.m_6469_(CMDamageTypes.foundry(this.f_58857_), (float)recipe.getEntityIngredient().getDamage())) {
                entityIn.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + RandomSource.m_216327_().m_188501_() * 0.4f);
            }
            if (!entityIn.m_6084_()) {
                for (FluidStack output : recipe.getFluidResults()) {
                    if (this.getTank().fill(output.copy(), IFluidHandler.FluidAction.SIMULATE) < output.getAmount()) continue;
                    this.getTank().fill(output.copy(), IFluidHandler.FluidAction.EXECUTE);
                }
            }
        } else if (!isFireImmune && this.foundry.getCurrentHeat() > 0) {
            entityIn.m_6469_(CMDamageTypes.foundry(this.f_58857_), 4.0f);
        }
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (CrucibleBlock.isLadle(state)) {
            state = (BlockState)state.m_61124_((Property)CrucibleBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().m_123342_() == this.m_58899_().m_123342_()));
            state = (BlockState)state.m_61124_((Property)CrucibleBlock.TOP, (Comparable)Boolean.valueOf(this.getController().m_123342_() + this.height - 1 == this.m_58899_().m_123342_()));
            this.f_58857_.m_7731_(this.m_58899_(), state, 6);
        }
        if (this.isController()) {
            this.updateState();
        }
        this.updateLadleState(!this.foundry.isActive());
        this.m_6596_();
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return this.getMaxHeight();
        }
        return this.getMaxWidth();
    }

    public FoundryTank getTank() {
        return this.tankInventory;
    }

    public int getMaxWidth() {
        return 5;
    }

    public int getMaxHeight() {
        return 4;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getTotalSize() {
        return this.width * this.width * this.height;
    }

    public int getBaseSize() {
        return this.getWidth() * this.getWidth();
    }

    public static int getCapacityFactor() {
        return 1000;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CrucibleBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        CMLang.translate("crucible.title", new Object[0]).forGoggles(tooltip);
        controllerBE.foundry.addToGoggleTooltip(tooltip, isPlayerSneaking, controllerBE.getBaseSize());
        CMLang.translate("crucible.capacity", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        FoundryTank tank = controllerBE.getTank();
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        CMLang.number(tank.getFillAmount()).add(mb).style(ChatFormatting.BLUE).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)tank.getCapacity()).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        tooltip.add((Component)Component.m_237119_());
        if (AllKeys.shiftDown()) {
            CMLang.translate("crucible.fluid_content", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            if (tank.isEmpty()) {
                CMLang.translate("crucible.empty", new Object[0]).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
            } else {
                for (FluidStack fluid : tank.fluids) {
                    CMLang.text("").add(CMLang.fluidName(fluid).add(CMLang.text(" ")).style(ChatFormatting.DARK_GRAY).add(CMLang.number(fluid.getAmount()).add(mb).style(ChatFormatting.BLUE))).forGoggles(tooltip, 1);
                }
            }
        } else {
            tooltip.add((Component)CMLang.translateDirect("crucible.hold_details", Component.m_237115_((String)"create.tooltip.keyShift").m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return true;
    }
}

