/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.CrucibleBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.FoundryTank;
import fr.lucreeper74.createmetallurgy.registries.CMPartialModels;
import java.util.Random;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CrucibleRenderer
extends SafeBlockEntityRenderer<CrucibleBlockEntity> {
    public CrucibleRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(CrucibleBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!be.isController()) {
            return;
        }
        if (be.foundry.isActive()) {
            this.renderAsController(be, partialTicks, ms, buffer, light, overlay);
        }
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
        float capHeight = 0.1875f;
        float tankHullWidth = 0.1953125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)be.height - 2.0f * capHeight - minPuddleHeight;
        float yMin = capHeight + minPuddleHeight;
        FoundryTank tank = be.tankInventory;
        for (FluidStack fluidStack : tank.fluids) {
            float level = (float)fluidStack.getAmount() / (float)be.tankInventory.getCapacity();
            if (level < 1.0f / (512.0f * totalHeight)) {
                return;
            }
            float clampedLevel = Mth.m_14036_((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
            if (fluidStack.isEmpty()) {
                return;
            }
            boolean top = fluidStack.getFluid().getFluidType().isLighterThanAir();
            float xMin = tankHullWidth;
            float xMax = xMin + (float)be.width - 2.0f * tankHullWidth;
            float yMax = yMin + clampedLevel;
            if (top) {
                yMin += totalHeight - clampedLevel;
                yMax += totalHeight - clampedLevel;
            }
            float zMin = tankHullWidth;
            float zMax = zMin + (float)be.width - 2.0f * tankHullWidth;
            ms.m_85836_();
            FluidRenderer.renderFluidBox((Fluid)fluidStack.getFluid(), (long)fluidStack.getAmount(), (float)xMin, (float)yMin, (float)zMin, (float)xMax, (float)yMax, (float)zMax, (MultiBufferSource)buffer, (PoseStack)ms, (int)light, (boolean)false, (boolean)true, (CompoundTag)fluidStack.getTag());
            ms.m_85849_();
            yMin = yMax;
        }
    }

    protected void renderAsController(CrucibleBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.m_58900_();
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        ms.m_85836_();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        msr.translate((float)be.width / 2.0f, 0.5f, (float)be.width / 2.0f);
        float dialPivotY = 0.40625f;
        float dialPivotZ = 0.5f;
        float progress = Mth.m_14036_((float)(be.foundry.gauge.getValue(partialTicks) + 0.5f), (float)0.0f, (float)1.05f);
        Random random = new Random();
        if (progress >= 1.0f) {
            progress += Mth.m_14036_((float)(random.nextFloat(0.02f) - 0.01f), (float)-0.01f, (float)0.01f);
        }
        for (Direction d : Iterate.horizontalDirections) {
            ms.m_85836_();
            float yRot = -d.m_122435_() - 90.0f;
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)CMPartialModels.THERMOMETER_GAUGE, (BlockState)blockState).rotateYDegrees(yRot)).uncenter()).translate((float)be.width / 2.0f - 0.375f, 0.0f, 0.0f)).light(light).renderInto(ms, vb);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)CMPartialModels.THERMOMETER_DIAL, (BlockState)blockState).rotateYDegrees(yRot)).uncenter()).translate((float)be.width / 2.0f - 0.375f, 0.0f, 0.0f)).translate(0.0f, dialPivotY, dialPivotZ)).rotateXDegrees(-180.0f * progress)).translate(0.0f, -dialPivotY, -dialPivotZ)).light(light).renderInto(ms, vb);
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    protected void renderItems(CrucibleBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        int tankIndex = 0;
        CrucibleBlockEntity controllerBE = be.getControllerBE();
        for (int yOffset = 0; yOffset < be.height; ++yOffset) {
            for (int xOffset = 0; xOffset < be.width; ++xOffset) {
                for (int zOffset = 0; zOffset < be.width; ++zOffset) {
                    ItemStack stack = controllerBE.foundry.inputInv.getStackInSlot(tankIndex);
                    if (!stack.m_41619_()) {
                        ms.m_85836_();
                        if (stack.m_41720_() instanceof BlockItem) {
                            ms.m_252880_((float)xOffset + 0.5f, (float)yOffset + 0.1f, (float)zOffset + 0.5f);
                            ms.m_85841_(2.5f, 2.5f, 2.5f);
                        } else {
                            ms.m_252880_((float)xOffset + 0.5f, (float)yOffset + 0.5f, (float)zOffset + 0.5f);
                        }
                        Minecraft mc = Minecraft.m_91087_();
                        mc.m_91291_().m_269128_(stack, ItemDisplayContext.GROUND, light, overlay, ms, buffer, (Level)mc.f_91073_, 0);
                        ms.m_85849_();
                    }
                    ++tankIndex;
                }
            }
        }
    }

    public boolean shouldRenderOffScreen(CrucibleBlockEntity be) {
        return be.isController();
    }
}

