/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.light_bulb;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.ResetableLazy;
import fr.lucreeper74.createmetallurgy.content.blocks.light_bulb.LightBulbAddressSlot;
import fr.lucreeper74.createmetallurgy.content.blocks.light_bulb.LightBulbBlock;
import fr.lucreeper74.createmetallurgy.content.blocks.light_bulb.network.address.NetworkAddressBehaviour;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LightBulbBlockEntity
extends SmartBlockEntity {
    private boolean receivedSignalChanged;
    private NetworkAddressBehaviour addressBehaviour;
    private int receivedSignal;
    private int transmittedSignal;
    ResetableLazy<DyeColor> colorProvider;
    public LerpedFloat glow = LerpedFloat.linear();

    public LightBulbBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.colorProvider = ResetableLazy.of(() -> {
            BlockState blockState = this.m_58900_();
            if (blockState.m_60734_() instanceof LightBulbBlock) {
                return ((LightBulbBlock)blockState.m_60734_()).getColor();
            }
            return DyeColor.WHITE;
        });
    }

    public DyeColor getColor() {
        return (DyeColor)this.colorProvider.get();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void addBehavioursDeferred(List<BlockEntityBehaviour> behaviours) {
        this.addressBehaviour = this.createAddressSlot();
        behaviours.add(this.addressBehaviour);
    }

    protected NetworkAddressBehaviour createAddressSlot() {
        return NetworkAddressBehaviour.networkNode(this, new LightBulbAddressSlot(), this::setSignal, this::getSignal);
    }

    public int getSignal() {
        return this.transmittedSignal;
    }

    public void setSignal(int strength) {
        if (this.receivedSignal != strength) {
            this.receivedSignalChanged = true;
        }
        this.receivedSignal = strength;
    }

    public void transmit(int strength) {
        this.transmittedSignal = strength;
        this.glow.chase((double)strength / 15.0, 0.5, LerpedFloat.Chaser.EXP);
        if (this.addressBehaviour != null) {
            this.addressBehaviour.notifySignalChange();
        }
    }

    public void initialize() {
        if (this.addressBehaviour == null) {
            this.addressBehaviour = this.createAddressSlot();
            this.attachBehaviourLate(this.addressBehaviour);
        }
        super.initialize();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("Receive", this.getReceivedSignal());
        compound.m_128379_("ReceivedChanged", this.receivedSignalChanged);
        compound.m_128405_("Transmit", this.transmittedSignal);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.receivedSignal = compound.m_128451_("Receive");
        this.receivedSignalChanged = compound.m_128471_("ReceivedChanged");
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            this.transmittedSignal = compound.m_128451_("Transmit");
        }
    }

    public void tick() {
        super.tick();
        BlockState blockState = this.m_58900_();
        int lightLevel = (Integer)blockState.m_61143_((Property)LightBulbBlock.LEVEL);
        if (this.f_58857_.f_46443_) {
            this.glow.tickChaser();
            this.glow.chase((double)lightLevel, (double)0.2f, LerpedFloat.Chaser.EXP);
        }
        if (this.receivedSignal != lightLevel) {
            this.receivedSignalChanged = true;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61124_((Property)LightBulbBlock.LEVEL, (Comparable)Integer.valueOf(this.receivedSignal)));
        }
        if (this.receivedSignalChanged) {
            this.f_58857_.m_6289_(this.m_58899_(), blockState.m_60734_());
            this.receivedSignalChanged = false;
        }
    }

    public int getReceivedSignal() {
        return this.receivedSignal;
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.colorProvider.reset();
    }
}

