/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.ponders;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.fluids.drain.ItemDrainBlockEntity;
import com.simibubi.create.content.fluids.pipes.SmartFluidPipeBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import fr.lucreeper74.createmetallurgy.content.blocks.foundry_lids.glassed_lid.GlassedFoundryLidBlock;
import fr.lucreeper74.createmetallurgy.content.blocks.foundry_lids.lid.FoundryLidBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.foundry_mixer.FoundryMixerBlockEntity;
import fr.lucreeper74.createmetallurgy.registries.CMFluids;
import fr.lucreeper74.createmetallurgy.registries.CMItems;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FoundryScenes {
    public static void foundryBasin(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("foundry_basin", "Melting Metals with Foundry Basin");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(10);
        BlockPos burnerPos = util.grid().at(1, 1, 2);
        BlockPos drainPos = util.grid().at(1, 1, 1);
        BlockPos depotPos = util.grid().at(2, 1, 1);
        BlockPos basinPos = burnerPos.m_7494_();
        BlockPos lidPos = basinPos.m_7494_();
        Vec3 drainTop = util.vector().blockSurface(drainPos, Direction.UP);
        Vec3 lidSide = util.vector().blockSurface(lidPos, Direction.WEST);
        Vec3 lidTrap = util.vector().of(1.75, 3.0, 2.5);
        scene.world().showSection(util.select().position(burnerPos), Direction.DOWN);
        scene.idle(10);
        scene.world().modifyBlock(basinPos, s -> (BlockState)s.m_61124_((Property)BasinBlock.FACING, (Comparable)Direction.DOWN), false);
        scene.world().showSection(util.select().position(basinPos), Direction.DOWN);
        scene.idle(10);
        Vec3 basinSide = util.vector().blockSurface(basinPos, Direction.WEST);
        scene.overlay().showText(80).attachKeyFrame().text("The Foundry Basin is comparable to a classic Basin...").pointAt(basinSide).placeNearTarget();
        scene.idle(90);
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.RED).text("...However, it can only hold 9 Items of the same type").pointAt(basinSide).placeNearTarget();
        scene.idle(90);
        scene.world().modifyBlock(lidPos, s -> (BlockState)s.m_61124_((Property)GlassedFoundryLidBlock.OPEN, (Comparable)Boolean.valueOf(true)), false);
        scene.world().showSection(util.select().position(lidPos), Direction.DOWN);
        scene.idle(10);
        scene.overlay().showText(80).attachKeyFrame().text("Put a Foundry Lid on top, and your Foundry is now ready!").pointAt(lidSide).placeNearTarget();
        scene.idle(90);
        ElementLink depotLink = scene.world().showIndependentSection(util.select().position(depotPos), Direction.EAST);
        scene.world().moveSection(depotLink, util.vector().of(-1.0, 0.0, 0.0), 0);
        scene.idle(10);
        scene.world().modifyBlock(basinPos, s -> (BlockState)s.m_61124_((Property)BasinBlock.FACING, (Comparable)Direction.NORTH), false);
        scene.idle(10);
        Vec3 faucet = basinSide.m_82520_(0.15, 0.0, -0.5);
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.GREEN).text("Like the Basin, a Faucet can extract recipes Items...").pointAt(faucet).placeNearTarget();
        scene.idle(90);
        scene.world().hideIndependentSection(depotLink, Direction.EAST);
        scene.idle(15);
        scene.world().showSection(util.select().position(drainPos), Direction.EAST);
        scene.idle(15);
        scene.overlay().showText(80).attachKeyFrame().text("...and Fluids with a Item Drain").pointAt(drainTop).placeNearTarget();
        scene.idle(90);
        scene.world().showSection(util.select().fromTo(2, 1, 2, 4, 1, 2), Direction.WEST);
        scene.idle(5);
        scene.world().showSection(util.select().position(2, 2, 2), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 1, 3, 3, 1, 5), Direction.NORTH);
        scene.idle(5);
        scene.world().showSection(util.select().position(2, 0, 5), Direction.NORTH);
        scene.idle(5);
        ItemStack goldDust = CMItems.GOLD_DUST.asStack();
        scene.world().createItemOnBelt(util.grid().at(4, 1, 2), Direction.UP, goldDust);
        scene.world().modifyBlock(burnerPos, s -> (BlockState)s.m_61124_((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.KINDLED), false);
        scene.idle(40);
        scene.overlay().showControls(basinSide, Pointing.LEFT, 20).withItem(CMItems.GOLD_DUST.asStack());
        scene.idle(30);
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.RED).text("Make sure to close the Foundry Top else the recipe won't start").pointAt(lidTrap).placeNearTarget();
        scene.idle(90);
        scene.overlay().showControls(lidTrap, Pointing.LEFT, 30).whileSneaking().rightClick();
        scene.idle(7);
        scene.world().modifyBlock(lidPos, s -> (BlockState)s.m_61124_((Property)GlassedFoundryLidBlock.OPEN, (Comparable)Boolean.valueOf(false)), false);
        scene.world().modifyBlockEntity(lidPos, FoundryLidBlockEntity.class, FoundryLidBlockEntity::startProcessingBasin);
        scene.idle(40);
        FluidStack gold = new FluidStack(FluidHelper.convertToStill((Fluid)((Fluid)CMFluids.MOLTEN_GOLD.get())), 1000);
        scene.effects().emitParticles(util.vector().centerOf(drainPos), scene.effects().simpleParticleEmitter(FluidFX.getFluidParticle((FluidStack)gold), Vec3.f_82478_), 3.0f, 20);
        scene.world().modifyBlockEntity(drainPos, ItemDrainBlockEntity.class, be -> {
            ((SmartFluidTankBehaviour)be.getBehaviour(SmartFluidTankBehaviour.TYPE)).allowInsertion();
            be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fh -> fh.fill(gold, IFluidHandler.FluidAction.EXECUTE));
        });
        scene.idle(10);
        scene.overlay().showControls(drainTop, Pointing.RIGHT, 30).withItem(((ForgeFlowingFluid.Flowing)CMFluids.MOLTEN_GOLD.get()).getFluidType().getBucket(gold));
        scene.idle(10);
    }

    public static void alloying(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("foundry_mixer", "Making Alloys with Foundry Mixer");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(10);
        BlockPos burner = util.grid().at(1, 1, 2);
        BlockPos basinPos = burner.m_7494_();
        BlockPos topPos = burner.m_6630_(2);
        BlockPos tankPos = util.grid().at(0, 0, 5);
        BlockPos mixer = util.grid().at(1, 4, 2);
        BlockPos inputDepot = util.grid().at(4, 1, 1);
        Vec3 burnerSide = util.vector().blockSurface(burner, Direction.WEST);
        Vec3 mixerSide = util.vector().blockSurface(mixer, Direction.WEST);
        Vec3 basinSide = util.vector().blockSurface(basinPos, Direction.EAST);
        Vec3 lidTrap = util.vector().of(1.75, 3.0, 2.5);
        scene.world().showSection(util.select().position(2, 0, 5), Direction.NORTH);
        scene.idle(5);
        scene.world().showSection(util.select().position(2, 1, 4), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 1, 3, 1, 4, 3), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().position(1, 1, 2), Direction.DOWN);
        scene.idle(5);
        scene.world().modifyBlock(basinPos, s -> (BlockState)s.m_61124_((Property)BasinBlock.FACING, (Comparable)Direction.DOWN), false);
        scene.world().showSection(util.select().position(basinPos), Direction.DOWN);
        scene.idle(5);
        scene.world().modifyBlock(topPos, s -> (BlockState)s.m_61124_((Property)GlassedFoundryLidBlock.OPEN, (Comparable)Boolean.valueOf(true)), false);
        scene.world().showSection(util.select().position(topPos), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().position(mixer), Direction.DOWN);
        scene.idle(10);
        scene.overlay().showText(80).attachKeyFrame().text("The Foundry Mixer is similar to the Mechanical Mixer...").pointAt(mixerSide).placeNearTarget();
        scene.idle(90);
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.RED).text("...However, it has a much higher stress impact").pointAt(mixerSide).placeNearTarget();
        scene.idle(90);
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.GREEN).text("With a Glassed Foundry Top between them, you will be able to make alloys").pointAt(util.vector().blockSurface(topPos, Direction.WEST)).placeNearTarget();
        scene.idle(90);
        scene.idle(10);
        scene.overlay().showText(80).text("In order to keep molten metals warm enough...").pointAt(burnerSide).placeNearTarget();
        scene.idle(90);
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.OUTPUT).text("...you will need a Heated Blaze Burner").pointAt(burnerSide).placeNearTarget();
        scene.idle(90);
        scene.overlay().showControls(burnerSide, Pointing.LEFT, 30).rightClick().withItem(AllItems.BLAZE_CAKE.asStack());
        scene.idle(7);
        scene.world().modifyBlock(burner, s -> (BlockState)s.m_61124_((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.KINDLED), false);
        scene.idle(20);
        scene.world().showSection(util.select().fromTo(0, 0, 5, 0, 3, 5), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().position(1, 2, 4), Direction.NORTH);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(0, 2, 2, 0, 2, 4), Direction.DOWN);
        scene.idle(10);
        FluidStack iron = new FluidStack(FluidHelper.convertToStill((Fluid)((Fluid)CMFluids.MOLTEN_IRON.get())), 32000);
        scene.world().modifyBlockEntity(tankPos, FluidTankBlockEntity.class, be -> be.getTankInventory().fill(iron, IFluidHandler.FluidAction.EXECUTE));
        scene.idle(5);
        scene.overlay().showControls(basinSide, Pointing.RIGHT, 30).withItem(((ForgeFlowingFluid.Flowing)CMFluids.MOLTEN_IRON.get()).getFluidType().getBucket(iron));
        scene.idle(40);
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.RED).text("Make sure to close the Foundry Top else the recipe won't start").pointAt(lidTrap).placeNearTarget();
        scene.idle(90);
        scene.overlay().showControls(lidTrap, Pointing.LEFT, 30).whileSneaking().rightClick();
        scene.idle(7);
        scene.world().modifyBlock(topPos, s -> (BlockState)s.m_61124_((Property)GlassedFoundryLidBlock.OPEN, (Comparable)Boolean.valueOf(false)), false);
        scene.idle(40);
        scene.rotateCameraY(70.0f);
        scene.idle(10);
        BlockPos armPos = util.grid().at(3, 1, 3);
        scene.world().showSection(util.select().position(armPos), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().position(inputDepot), Direction.DOWN);
        scene.idle(5);
        ItemStack coke = CMItems.COKE.asStack();
        scene.world().setKineticSpeed(util.select().position(armPos), -96.0f);
        scene.idle(10);
        scene.world().createItemOnBeltLike(inputDepot, Direction.UP, coke);
        scene.idle(12);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, ItemStack.f_41583_, 0);
        scene.idle(10);
        scene.world().removeItemsFromBelt(inputDepot);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_OUTPUTS, coke, 1);
        scene.idle(12);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_OUTPUT, coke, 0);
        scene.idle(10);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_INPUTS, ItemStack.f_41583_, 1);
        scene.world().modifyBlockEntity(mixer, FoundryMixerBlockEntity.class, MechanicalMixerBlockEntity::startProcessingBasin);
        scene.idle(40);
        scene.world().showSection(util.select().position(0, 1, 3), Direction.EAST);
        scene.world().showSection(util.select().position(0, 1, 2), Direction.EAST);
        scene.world().showSection(util.select().position(0, 1, 1), Direction.EAST);
        scene.world().showSection(util.select().position(0, 1, 0), Direction.EAST);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 1, 0, 1, 2, 1), Direction.SOUTH);
        Vec3 smartPipeFilter = util.vector().topOf(util.grid().at(1, 2, 1)).m_82492_(0.0, 0.0, 0.25);
        scene.overlay().showText(80).attachKeyFrame().text("If you are using Fluid Pipes instead of a Item Drain...").pointAt(smartPipeFilter).placeNearTarget();
        scene.idle(90);
        scene.overlay().showFilterSlotInput(smartPipeFilter, Direction.NORTH, 80);
        scene.overlay().showText(80).text("...you might use a Smart Fluid Pipe, to avoid pumping out un-processed Fluids").pointAt(smartPipeFilter).placeNearTarget();
        scene.idle(90);
        FluidStack steel = new FluidStack(FluidHelper.convertToStill((Fluid)((Fluid)CMFluids.MOLTEN_STEEL.get())), 1000);
        ItemStack steelBucket = ((ForgeFlowingFluid.Flowing)CMFluids.MOLTEN_STEEL.get()).getFluidType().getBucket(steel);
        scene.overlay().showControls(smartPipeFilter, Pointing.DOWN, 30).rightClick().withItem(steelBucket);
        scene.idle(7);
        scene.world().setFilterData(util.select().position(1, 2, 1), SmartFluidPipeBlockEntity.class, steelBucket);
        scene.idle(10);
        scene.markAsFinished();
    }
}

