/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.registries;

import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import fr.lucreeper74.createmetallurgy.CreateMetallurgy;
import fr.lucreeper74.createmetallurgy.content.blocks.belt_grinder.GrindingRecipe;
import fr.lucreeper74.createmetallurgy.content.blocks.casting.recipe.CastingRecipeSerializer;
import fr.lucreeper74.createmetallurgy.content.blocks.foundry_lids.lid.MeltingRecipe;
import fr.lucreeper74.createmetallurgy.content.blocks.foundry_mixer.AlloyingRecipe;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.recipes.BulkMeltingRecipe;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.recipes.EntityMeltingRecipe;
import fr.lucreeper74.createmetallurgy.utils.CMLang;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public enum CMRecipeTypes implements IRecipeTypeInfo
{
    MELTING(MeltingRecipe::new),
    ALLOYING(AlloyingRecipe::new),
    GRINDING(GrindingRecipe::new),
    BULK_MELTING(BulkMeltingRecipe::new),
    ENTITY_MELTING(EntityMeltingRecipe::new),
    CASTING_IN_BASIN(CastingRecipeSerializer.CastingBasinRecipeSerializer::new),
    CASTING_IN_TABLE(CastingRecipeSerializer.CastingTableRecipeSerializer::new);

    private final ResourceLocation id;
    private final RegistryObject<RecipeSerializer<?>> serializerObject;
    private final Supplier<RecipeType<?>> type;

    private CMRecipeTypes(Supplier<RecipeSerializer<?>> serializerSupplier) {
        RegistryObject typeObject;
        String name = CMLang.asId(this.name());
        this.id = CreateMetallurgy.genRL(name);
        this.serializerObject = Registers.SERIALIZER_REGISTER.register(name, serializerSupplier);
        this.type = typeObject = Registers.TYPE_REGISTER.register(name, () -> RecipeType.simple((ResourceLocation)this.id));
    }

    private CMRecipeTypes(ProcessingRecipeBuilder.ProcessingRecipeFactory<?> processingFactory) {
        this(() -> new ProcessingRecipeSerializer(processingFactory));
    }

    public static void register(IEventBus modEventBus) {
        Registers.SERIALIZER_REGISTER.register(modEventBus);
        Registers.TYPE_REGISTER.register(modEventBus);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public <T extends RecipeSerializer<?>> T getSerializer() {
        return (T)((RecipeSerializer)this.serializerObject.get());
    }

    public <T extends RecipeType<?>> T getType() {
        return (T)this.type.get();
    }

    private static class Registers {
        private static final DeferredRegister<RecipeSerializer<?>> SERIALIZER_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"createmetallurgy");
        private static final DeferredRegister<RecipeType<?>> TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256954_, (String)"createmetallurgy");

        private Registers() {
        }
    }
}

