/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

@OnlyIn(value=Dist.CLIENT)
public class ColoredFluidRenderer
extends FluidRenderer {
    public static int RGBAtoColor(int r, int g, int b, int a) {
        return b | g << 8 | r << 16 | a << 24;
    }

    public static void renderFluidBox(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, MultiBufferSource buffer, PoseStack ms, int light, int color, boolean renderBottom) {
        ColoredFluidRenderer.renderFluidBox(fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, ColoredFluidRenderer.getFluidBuilder((MultiBufferSource)buffer), ms, light, color, renderBottom);
    }

    public static void renderFluidBox(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, VertexConsumer builder, PoseStack ms, int light, int color, boolean renderBottom) {
        if (fluidStack.isEmpty()) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid);
        FluidType fluidAttributes = fluid.getFluidType();
        TextureAtlasSprite fluidTexture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(clientFluid.getStillTexture(fluidStack));
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluidAttributes.getLightLevel(fluidStack));
        light = light & 0xF00000 | luminosity << 4;
        Vec3 center = new Vec3((double)(xMin + (xMax - xMin) / 2.0f), (double)(yMin + (yMax - yMin) / 2.0f), (double)(zMin + (zMax - zMin) / 2.0f));
        ms.m_85836_();
        if (fluidAttributes.isLighterThanAir()) {
            ((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).translate(center)).rotateX(180.0f)).translateBack(center);
        }
        for (Direction side : Iterate.directions) {
            boolean positive;
            if (side == Direction.DOWN && !renderBottom) continue;
            boolean bl = positive = side.m_122421_() == Direction.AxisDirection.POSITIVE;
            if (side.m_122434_().m_122479_()) {
                if (side.m_122434_() == Direction.Axis.X) {
                    ColoredFluidRenderer.renderStillTiledFace((Direction)side, (float)zMin, (float)yMin, (float)zMax, (float)yMax, (float)(positive ? xMax : xMin), (VertexConsumer)builder, (PoseStack)ms, (int)light, (int)color, (TextureAtlasSprite)fluidTexture);
                    continue;
                }
                ColoredFluidRenderer.renderStillTiledFace((Direction)side, (float)xMin, (float)yMin, (float)xMax, (float)yMax, (float)(positive ? zMax : zMin), (VertexConsumer)builder, (PoseStack)ms, (int)light, (int)color, (TextureAtlasSprite)fluidTexture);
                continue;
            }
            ColoredFluidRenderer.renderStillTiledFace((Direction)side, (float)xMin, (float)zMin, (float)xMax, (float)zMax, (float)(positive ? yMax : yMin), (VertexConsumer)builder, (PoseStack)ms, (int)light, (int)color, (TextureAtlasSprite)fluidTexture);
        }
        ms.m_85849_();
    }
}

