/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.mixin;

import com.supermartijn642.formations.Formations;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={StructureTemplate.class})
public class StructureTemplateMixin {
    @ModifyVariable(method={"processBlockInfos(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;Ljava/util/List;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate;)Ljava/util/List;"}, at=@At(value="HEAD"), ordinal=0, remap=false)
    private static List<StructureTemplate.StructureBlockInfo> processBlockInfos(List<StructureTemplate.StructureBlockInfo> blocks, ServerLevelAccessor level, BlockPos piecePosition, BlockPos structurePosition, StructurePlaceSettings placeSettings) {
        List<FormationsStructureProcessor> processors = placeSettings.m_74411_().stream().filter(FormationsStructureProcessor.class::isInstance).map(FormationsStructureProcessor.class::cast).toList();
        if (processors.isEmpty()) {
            return blocks;
        }
        Map<BlockPos, BlockInstance> blocksByPosition = blocks.stream().collect(Collectors.toUnmodifiableMap(block -> block.f_74675_().m_121955_((Vec3i)piecePosition), block -> new BlockInstance(block.f_74676_(), block.f_74677_())));
        ArrayList<StructureTemplate.StructureBlockInfo> newBlocks = new ArrayList<StructureTemplate.StructureBlockInfo>(blocks.size());
        for (Map.Entry<BlockPos, BlockInstance> entry : blocksByPosition.entrySet()) {
            BlockPos pos = entry.getKey();
            BlockInstance block2 = entry.getValue();
            for (FormationsStructureProcessor processor : processors) {
                try {
                    BlockInstance newBlock = processor.processBlock(block2, pos, (LevelReader)level, piecePosition, structurePosition, placeSettings, blocksByPosition);
                    if (newBlock == null) {
                        throw new NullPointerException("Processor returned null!");
                    }
                    block2 = newBlock;
                }
                catch (Exception e) {
                    Formations.LOGGER.error("Encountered an exception whilst processing block '" + block2 + "' with processor of class '" + processor.getClass() + "'!", (Throwable)e);
                }
            }
            if (block2.state() == null) continue;
            newBlocks.add(new StructureTemplate.StructureBlockInfo(pos.m_121996_((Vec3i)piecePosition), block2.state(), block2.nbt()));
        }
        return newBlocks;
    }
}

