/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtterralith.cellkits;

import com.ferreusveritas.dynamictrees.api.cell.Cell;
import com.ferreusveritas.dynamictrees.api.cell.CellKit;
import com.ferreusveritas.dynamictrees.api.cell.CellNull;
import com.ferreusveritas.dynamictrees.api.cell.CellSolver;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.cell.CellKits;
import com.ferreusveritas.dynamictrees.cell.NormalCell;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import maxhyper.dtterralith.DynamicTreesTerralith;
import maxhyper.dtterralith.cellkits.DTTerralithLeafClusters;
import maxhyper.dtterralith.cellkits.cell.PoplarBranchCell;
import maxhyper.dtterralith.cellkits.cell.PoplarLeafCell;
import maxhyper.dtterralith.cellkits.cell.PoplarTopBranchCell;
import maxhyper.dtterralith.cellkits.cell.SparseBranchCell;
import maxhyper.dtterralith.cellkits.cell.WideDarkOakLeafCell;
import net.minecraft.resources.ResourceLocation;

public class DTTerralithCellKits {
    public static final CellKit SPARSE = new CellKit(new ResourceLocation("dtterralith", "sparse")){
        private final Cell sparseBranch = new SparseBranchCell();
        private final Cell sparseLeaves = new NormalCell(1);
        private final CellSolver solver = new CellKits.BasicSolver(new short[]{529});

        public Cell getCellForLeaves(int hydro) {
            return hydro > 0 ? this.sparseLeaves : CellNull.NULL_CELL;
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.sparseBranch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTTerralithLeafClusters.SPARSE;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 1;
        }
    };
    public static final CellKit POPLAR = new CellKit(new ResourceLocation("dtterralith", "poplar")){
        private final Cell poplarBranch = new PoplarBranchCell();
        private final Cell poplarTopBranch = new PoplarTopBranchCell();
        private final Cell poplarUpperTrunk = new NormalCell(4);
        private final Cell[] poplarLeaves = new Cell[]{CellNull.NULL_CELL, new PoplarLeafCell(1), new PoplarLeafCell(2), new PoplarLeafCell(3), new PoplarLeafCell(4)};
        private final CellSolver solver = new CellKits.BasicSolver(new short[]{1042, 785, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.poplarLeaves[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.poplarTopBranch;
            }
            if (radius == 1) {
                return this.poplarBranch;
            }
            if (radius < 4) {
                return this.poplarUpperTrunk;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTTerralithLeafClusters.POPLAR;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit WIDE_DARK_OAK = new CellKit(DynamicTreesTerralith.location("wide_dark_oak")){
        private final Cell branchCell = new NormalCell(8);
        private final Cell[] darkOakLeafCells = new Cell[]{CellNull.NULL_CELL, new WideDarkOakLeafCell(1), new WideDarkOakLeafCell(2), new WideDarkOakLeafCell(3), new WideDarkOakLeafCell(4), new WideDarkOakLeafCell(5), new WideDarkOakLeafCell(6), new WideDarkOakLeafCell(7)};
        private final CellKits.BasicSolver darkOakSolver = new CellKits.BasicSolver(new short[]{2071, 1830, 1813, 1557, 1300, 1043, 802, 545});

        public Cell getCellForLeaves(int hydro) {
            return this.darkOakLeafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.branchCell : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTTerralithLeafClusters.WIDE_DARK_OAK;
        }

        public CellSolver getCellSolver() {
            return this.darkOakSolver;
        }

        public int getDefaultHydration() {
            return 7;
        }
    };

    public static void register(Registry<CellKit> registry) {
        registry.registerAll((RegistryEntry[])new CellKit[]{SPARSE, POPLAR, WIDE_DARK_OAK});
    }
}

