/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtterralith.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public class TwistingTreeLogic
extends GrowthLogicKit {
    public static final ConfigurationProperty<Float> CHANCE_TO_SPLIT = ConfigurationProperty.floatProperty((String)"chance_to_split");
    public static final ConfigurationProperty<Integer> DOWN_PROBABILITY = ConfigurationProperty.integer((String)"down_probability");
    public static final ConfigurationProperty<Integer> SPLIT_ENDS_ENERGY = ConfigurationProperty.integer((String)"split_ends_energy");

    public TwistingTreeLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(CHANCE_TO_SPLIT, (Object)Float.valueOf(0.01f))).with(DOWN_PROBABILITY, (Object)0)).with(HEIGHT_VARIATION, (Object)3)).with(SPLIT_ENDS_ENERGY, (Object)3);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{CHANCE_TO_SPLIT, DOWN_PROBABILITY, HEIGHT_VARIATION, SPLIT_ENDS_ENERGY});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        Level level = context.level();
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        BlockPos pos = context.pos();
        Direction originDir = signal.dir.m_122424_();
        int count = 0;
        for (Direction direction : Direction.values()) {
            int rad = TreeHelper.getRadius((BlockGetter)level, (BlockPos)pos.m_121955_(direction.m_122436_()));
            if (rad > 0) {
                ++count;
            }
            probMap[direction.ordinal()] = rad + (level.m_213780_().m_188501_() < ((Float)configuration.get(CHANCE_TO_SPLIT)).floatValue() ? 1 : 0);
        }
        if (count <= 1 || signal.energy < (float)((Integer)configuration.get(SPLIT_ENDS_ENERGY)).intValue()) {
            probMap[0] = (Integer)configuration.get(DOWN_PROBABILITY);
            probMap[1] = context.species().getUpProbability();
            probMap[5] = 1;
            probMap[4] = 1;
            probMap[3] = 1;
            probMap[2] = 1;
        }
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }

    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        long day = context.level().m_46467_() / 24000L;
        int month = (int)day / 30;
        return super.getEnergy(configuration, context) * context.species().biomeSuitability(context.level(), context.pos()) + (float)(CoordUtils.coordHashCode((BlockPos)context.pos().m_6630_(month), (int)3) % (Integer)configuration.get(HEIGHT_VARIATION));
    }
}

