/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client;

import artifacts.Artifacts;
import artifacts.component.SwimData;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModGameRules;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class HeliumFlamingoOverlay {
    private static final ResourceLocation HELIUM_FLAMINGO_ICON = Artifacts.id("textures/gui/icons.png");

    public static boolean renderOverlay(int height, GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        Entity entity;
        boolean isEnabled;
        boolean bl = isEnabled = ModGameRules.HELIUM_FLAMINGO_FLIGHT_DURATION.get() > 0;
        if (!isEnabled || !((entity = Minecraft.m_91087_().m_91288_()) instanceof LivingEntity)) {
            return false;
        }
        LivingEntity player = (LivingEntity)entity;
        SwimData swimData = PlatformServices.platformHelper.getSwimData(player);
        if (swimData == null) {
            return false;
        }
        int swimTime = swimData.getSwimTime();
        RenderSystem.enableBlend();
        int left = screenWidth / 2 + 91;
        int top = screenHeight - height;
        if (Math.abs(swimTime) == 0) {
            return false;
        }
        int maxProgressTime = swimTime > 0 ? Math.max(1, ModGameRules.HELIUM_FLAMINGO_FLIGHT_DURATION.get()) : Math.max(20, ModGameRules.HELIUM_FLAMINGO_RECHARGE_DURATION.get());
        float progress = 1.0f - (float)Math.abs(swimTime) / (float)maxProgressTime;
        int full = Mth.m_14165_((double)(((double)progress - 2.0 / (double)maxProgressTime) * 10.0));
        int partial = Mth.m_14167_((float)(progress * 10.0f)) - full;
        for (int i = 0; i < full + partial; ++i) {
            guiGraphics.m_280398_(HELIUM_FLAMINGO_ICON, left - i * 8 - 9, top, -90, (float)(i < full ? 0 : 9), 0.0f, 9, 9, 32, 16);
        }
        RenderSystem.disableBlend();
        return true;
    }
}

