/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item;

import artifacts.Artifacts;
import artifacts.registry.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class ArtifactItem
extends Item {
    public ArtifactItem(Item.Properties properties) {
        super(properties.arch$tab(ModItems.CREATIVE_TAB.getRegistrySupplier()).m_41487_(1).m_41497_(Rarity.RARE).m_41486_());
    }

    public ArtifactItem() {
        this(new Item.Properties());
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltipList, TooltipFlag flags) {
        if (Artifacts.CONFIG.client.showTooltips) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            this.addTooltip(stack, tooltip);
            tooltip.forEach(line -> tooltipList.add((Component)line.m_130940_(ChatFormatting.GRAY)));
        }
    }

    protected void addTooltip(ItemStack stack, List<MutableComponent> tooltip) {
        if (this.isCosmetic()) {
            tooltip.add(Component.m_237115_((String)"%s.tooltip.cosmetic".formatted("artifacts")).m_130940_(ChatFormatting.ITALIC));
        } else {
            this.addEffectsTooltip(stack, tooltip);
        }
    }

    protected void addEffectsTooltip(ItemStack stack, List<MutableComponent> tooltip) {
        tooltip.add(Component.m_237115_((String)"%s.tooltip.item.%s".formatted("artifacts", this.getTooltipItemName())));
    }

    protected MutableComponent tooltipLine(String lineId, Object ... args) {
        return Component.m_237110_((String)"%s.tooltip.item.%s.%s".formatted("artifacts", this.getTooltipItemName(), lineId), (Object[])args);
    }

    protected String getTooltipItemName() {
        return BuiltInRegistries.f_257033_.m_7981_((Object)this).m_135815_();
    }

    public abstract boolean isCosmetic();

    public boolean isOnCooldown(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_36335_().m_41519_((Item)this);
        }
        return false;
    }

    public void addCooldown(LivingEntity entity, int ticks) {
        if (ticks > 0 && !entity.m_9236_().m_5776_() && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_36335_().m_41524_((Item)this, ticks);
        }
    }
}

