/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import twilightforest.block.TFHorizontalBlock;
import twilightforest.enums.NagastoneVariant;
import twilightforest.init.TFBlocks;

public class NagastoneBlock
extends Block {
    public static final EnumProperty<NagastoneVariant> VARIANT = EnumProperty.m_61587_((String)"variant", NagastoneVariant.class);

    public NagastoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(VARIANT, (Comparable)((Object)NagastoneVariant.SOLID)));
    }

    public BlockState m_7417_(BlockState state, Direction directionToNeighbor, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        return this.getVariant(accessor, pos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getVariant((LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    private BlockState getVariant(LevelAccessor accessor, BlockPos pos) {
        BlockState stateOut;
        int connectionCount = 0;
        Direction[] facings = new Direction[2];
        for (Direction side : Direction.values()) {
            BlockState neighborState = accessor.m_8055_(pos.m_121945_(side));
            if (neighborState.m_60734_() != this && (neighborState.m_60734_() != TFBlocks.NAGASTONE_HEAD.get() || side != neighborState.m_61143_((Property)TFHorizontalBlock.f_54117_))) continue;
            facings[connectionCount++] = side;
            if (connectionCount >= 2) break;
        }
        switch (connectionCount) {
            case 1: {
                facings[1] = facings[0];
            }
            case 2: {
                stateOut = (BlockState)this.m_49966_().m_61124_(VARIANT, (Comparable)((Object)NagastoneVariant.getVariantFromDoubleFacing(facings[0], facings[1])));
                break;
            }
            default: {
                stateOut = this.m_49966_();
            }
        }
        return stateOut;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{VARIANT});
    }
}

