/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import twilightforest.entity.monster.IceCrystal;

public class IceCrystalModel
extends HierarchicalModel<IceCrystal> {
    private final ModelPart root;
    private final ModelPart[] spikes = new ModelPart[16];
    private boolean alive;

    public IceCrystalModel(ModelPart root) {
        super(RenderType::m_110473_);
        this.root = root;
        for (int i = 0; i < this.spikes.length; ++i) {
            this.spikes[i] = root.m_171324_("spike_" + i);
        }
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition partRoot = mesh.m_171576_();
        for (int i = 0; i < 16; ++i) {
            int spikeLength = i % 2 == 0 ? 6 : 8;
            PartDefinition spike = partRoot.m_171599_("spike_" + i, CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, (float)spikeLength, 2.0f), PartPose.f_171404_);
            spike.m_171599_("cube_" + i, CubeListBuilder.m_171558_().m_171514_(8, 16).m_171481_(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)spikeLength, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        }
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int light, int overlay, float red, float green, float blue, float alpha) {
        for (ModelPart spike : this.spikes) {
            spike.m_104306_(stack, builder, light, overlay, red, green, blue, this.alive ? 0.6f : alpha);
        }
    }

    public void setupAnim(IceCrystal entity, float v, float v1, float v2, float v3, float v4) {
    }

    public void prepareMobModel(IceCrystal entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.alive = entity.m_6084_();
        for (int i = 0; i < this.spikes.length; ++i) {
            this.spikes[i].f_104203_ = Mth.m_14031_((float)(((float)entity.f_19797_ + partialTicks) / 5.0f)) / 4.0f;
            this.spikes[i].f_104204_ = ((float)entity.f_19797_ + partialTicks) / 5.0f;
            this.spikes[i].f_104205_ = Mth.m_14089_((float)(((float)entity.f_19797_ + partialTicks) / 5.0f)) / 4.0f;
            this.spikes[i].f_104203_ = (float)((double)this.spikes[i].f_104203_ + (double)i * 0.39269908169872414);
            if (i % 4 == 0) {
                this.spikes[i].f_104204_ += 1.0f;
                continue;
            }
            if (i % 4 != 2) continue;
            this.spikes[i].f_104204_ -= 1.0f;
        }
    }
}

