/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.gameevent.GameEvent;
import twilightforest.entity.boss.KnightPhantom;
import twilightforest.entity.projectile.ThrownWep;
import twilightforest.init.TFEntities;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;

public class PhantomThrowWeaponGoal
extends Goal {
    private final KnightPhantom boss;

    public PhantomThrowWeaponGoal(KnightPhantom entity) {
        this.boss = entity;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.boss.m_5448_() != null && this.boss.getCurrentFormation() == KnightPhantom.Formation.ATTACK_PLAYER_ATTACK;
    }

    public void m_8037_() {
        if (this.boss.m_5448_() != null && this.boss.getTicksProgress() % 4 == 0) {
            if (this.boss.isAxeKnight()) {
                this.launchAxeAt((Entity)this.boss.m_5448_());
            } else if (this.boss.isPickKnight()) {
                this.launchPicks();
            }
        }
    }

    private void launchAxeAt(Entity targetedEntity) {
        float bodyFacingAngle = this.boss.f_20883_ * (float)Math.PI / 180.0f;
        double sx = this.boss.m_20185_() + (double)(Mth.m_14089_((float)bodyFacingAngle) * 1.0f);
        double sy = this.boss.m_20186_() + (double)this.boss.m_20206_() * 0.82;
        double sz = this.boss.m_20189_() + (double)(Mth.m_14031_((float)bodyFacingAngle) * 1.0f);
        double tx = targetedEntity.m_20185_() - sx;
        double ty = targetedEntity.m_20191_().f_82289_ + (double)(targetedEntity.m_20206_() / 2.0f) - (this.boss.m_20186_() + (double)(this.boss.m_20206_() / 2.0f));
        double tz = targetedEntity.m_20189_() - sz;
        this.boss.m_5496_((SoundEvent)TFSounds.KNIGHT_PHANTOM_THROW_AXE.get(), 1.0f, (this.boss.m_217043_().m_188501_() - this.boss.m_217043_().m_188501_()) * 0.2f + 0.4f);
        this.boss.m_146850_(GameEvent.f_157778_);
        ThrownWep projectile = new ThrownWep((EntityType<? extends ThrownWep>)((EntityType)TFEntities.THROWN_WEP.get()), this.boss.m_9236_(), (LivingEntity)this.boss).setItem(new ItemStack((ItemLike)TFItems.KNIGHTMETAL_AXE.get()));
        float speed = 0.75f;
        projectile.m_6686_(tx, ty, tz, speed, 1.0f);
        projectile.m_7678_(sx, sy, sz, this.boss.m_146908_(), this.boss.m_146909_());
        this.boss.m_9236_().m_7967_((Entity)projectile);
    }

    private void launchPicks() {
        this.boss.m_5496_((SoundEvent)TFSounds.KNIGHT_PHANTOM_THROW_PICK.get(), 1.0f, (this.boss.m_217043_().m_188501_() - this.boss.m_217043_().m_188501_()) * 0.2f + 0.4f);
        this.boss.m_146850_(GameEvent.f_157778_);
        for (int i = 0; i < 8; ++i) {
            float throwAngle = (float)i * (float)Math.PI / 4.0f;
            double sx = this.boss.m_20185_() + (double)(Mth.m_14089_((float)throwAngle) * 1.0f);
            double sy = this.boss.m_20186_() + (double)this.boss.m_20206_() * 0.82;
            double sz = this.boss.m_20189_() + (double)(Mth.m_14031_((float)throwAngle) * 1.0f);
            double vx = Mth.m_14089_((float)throwAngle);
            double vy = 0.0;
            double vz = Mth.m_14031_((float)throwAngle);
            ThrownWep projectile = new ThrownWep((EntityType<? extends ThrownWep>)((EntityType)TFEntities.THROWN_WEP.get()), this.boss.m_9236_(), (LivingEntity)this.boss).setDamage(3.0f).setVelocity(0.015f).setItem(new ItemStack((ItemLike)TFItems.KNIGHTMETAL_PICKAXE.get()));
            projectile.m_7678_(sx, sy, sz, (float)i * 45.0f, this.boss.m_146909_());
            float speed = 0.5f;
            projectile.m_6686_(vx, vy, vz, speed, 1.0f);
            this.boss.m_9236_().m_7967_((Entity)projectile);
        }
    }
}

