/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFConfig;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFChestBlock;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFStructures;
import twilightforest.loot.TFLootTables;
import twilightforest.util.EntityUtil;
import twilightforest.util.LandmarkUtil;

public class PlateauBoss
extends Monster
implements EnforcedHomePoint {
    private static final EntityDataAccessor<Optional<GlobalPos>> HOME_POINT = SynchedEntityData.m_135353_(PlateauBoss.class, (EntityDataSerializer)EntityDataSerializers.f_238113_);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
    private final List<ServerPlayer> hurtBy = new ArrayList<ServerPlayer>();

    public PlateauBoss(EntityType<? extends PlateauBoss> type, Level world) {
        super(type, world);
        this.f_21364_ = 647;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_();
    }

    protected void m_8099_() {
    }

    public void m_8107_() {
        if (!this.m_9236_().m_5776_()) {
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            if (this.isRestrictionPointValid(this.m_9236_().m_46472_()) && this.m_9236_().m_46749_(this.getRestrictionPoint().m_122646_())) {
                this.m_9236_().m_46597_(this.getRestrictionPoint().m_122646_(), ((Block)TFBlocks.FINAL_BOSS_BOSS_SPAWNER.get()).m_49966_());
            }
            this.m_146870_();
        } else {
            super.m_6043_();
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        ServerPlayer player;
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer && !this.hurtBy.contains(player = (ServerPlayer)entity)) {
            this.hurtBy.add(player);
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (!this.m_9236_().m_5776_()) {
            this.bossInfo.m_142711_(0.0f);
            LandmarkUtil.markStructureConquered(this.m_9236_(), this, TFStructures.FINAL_CASTLE, true);
            for (ServerPlayer player : this.hurtBy) {
                TFAdvancements.HURT_BOSS.trigger(player, (Entity)this);
            }
        }
        TFLootTables.entityDropsIntoContainer((LivingEntity)this, cause, ((TFChestBlock)((Object)TFBlocks.SORTING_CHEST.get())).m_49966_(), EntityUtil.bossChestLocation(this));
    }

    protected boolean m_6125_() {
        return (Boolean)TFConfig.COMMON_CONFIG.bossDropChests.get() == false;
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_7380_(CompoundTag compound) {
        this.saveHomePointToNbt(compound);
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.loadHomePointFromNbt(compound);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected float m_6108_() {
        return 1.0f;
    }

    public boolean m_6072_() {
        return false;
    }

    @Override
    @Nullable
    public GlobalPos getRestrictionPoint() {
        return ((Optional)this.m_20088_().m_135370_(HOME_POINT)).orElse(null);
    }

    @Override
    public void setRestrictionPoint(@Nullable GlobalPos pos) {
        this.m_20088_().m_135381_(HOME_POINT, Optional.ofNullable(pos));
    }

    @Override
    public int getHomeRadius() {
        return 30;
    }
}

