/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.config;

import nx.pingwheel.common.config.IConfig;
import nx.pingwheel.common.core.ServerCore;
import nx.pingwheel.common.helper.ChannelMode;

public class ServerConfig
implements IConfig {
    ChannelMode defaultChannelMode = ChannelMode.AUTO;
    boolean playerTrackingEnabled = true;
    int msToRegenerate = 1000;
    int rateLimit = 5;

    @Override
    public void validate() {
        if (this.msToRegenerate < 0) {
            this.msToRegenerate = 1000;
        }
        if (this.rateLimit < 0) {
            this.rateLimit = 0;
        }
    }

    @Override
    public void onUpdate() {
        ServerCore.init();
    }

    public ChannelMode getDefaultChannelMode() {
        return this.defaultChannelMode;
    }

    public boolean isPlayerTrackingEnabled() {
        return this.playerTrackingEnabled;
    }

    public int getMsToRegenerate() {
        return this.msToRegenerate;
    }

    public int getRateLimit() {
        return this.rateLimit;
    }

    public void setDefaultChannelMode(ChannelMode defaultChannelMode) {
        this.defaultChannelMode = defaultChannelMode;
    }

    public void setPlayerTrackingEnabled(boolean playerTrackingEnabled) {
        this.playerTrackingEnabled = playerTrackingEnabled;
    }

    public void setMsToRegenerate(int msToRegenerate) {
        this.msToRegenerate = msToRegenerate;
    }

    public void setRateLimit(int rateLimit) {
        this.rateLimit = rateLimit;
    }

    public String toString() {
        return "ServerConfig(defaultChannelMode=" + String.valueOf((Object)this.getDefaultChannelMode()) + ", playerTrackingEnabled=" + this.isPlayerTrackingEnabled() + ", msToRegenerate=" + this.getMsToRegenerate() + ", rateLimit=" + this.getRateLimit() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerConfig)) {
            return false;
        }
        ServerConfig other = (ServerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPlayerTrackingEnabled() != other.isPlayerTrackingEnabled()) {
            return false;
        }
        if (this.getMsToRegenerate() != other.getMsToRegenerate()) {
            return false;
        }
        if (this.getRateLimit() != other.getRateLimit()) {
            return false;
        }
        ChannelMode this$defaultChannelMode = this.getDefaultChannelMode();
        ChannelMode other$defaultChannelMode = other.getDefaultChannelMode();
        return !(this$defaultChannelMode == null ? other$defaultChannelMode != null : !((Object)((Object)this$defaultChannelMode)).equals((Object)other$defaultChannelMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPlayerTrackingEnabled() ? 79 : 97);
        result = result * 59 + this.getMsToRegenerate();
        result = result * 59 + this.getRateLimit();
        ChannelMode $defaultChannelMode = this.getDefaultChannelMode();
        result = result * 59 + ($defaultChannelMode == null ? 43 : ((Object)((Object)$defaultChannelMode)).hashCode());
        return result;
    }
}

