/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.block.entity;

import de.markusbordihn.easynpc.block.BaseEasyNPCSpawnerBlock;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.item.configuration.EasyNPCPresetItem;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseEasyNPCSpawnerBlockEntity
extends BaseContainerBlockEntity {
    public static final int BLOCK_POS_X_DATA = 0;
    public static final int BLOCK_POS_Y_DATA = 1;
    public static final int BLOCK_POS_Z_DATA = 2;
    public static final int DATA_SIZE = 9;
    public static final int DELAY_DATA = 5;
    public static final String DELAY_TAG = "Delay";
    public static final int DESPAWN_RANGE_DATA = 8;
    public static final String DESPAWN_RANGE_TAG = "DespawnRange";
    public static final int MAX_NEARBY_ENTITIES_DATA = 6;
    public static final String MAX_NEARBY_ENTITIES_TAG = "MaxNearbyEntities";
    public static final String NAME = "easy_npc_spawner_entity";
    public static final int REQUIRED_PLAYER_RANGE_DATA = 4;
    public static final String REQUIRED_PLAYER_RANGE_TAG = "RequiredPlayerRange";
    public static final String SPAWNER_OWNER_TAG = "Owner";
    public static final int SPAWNER_TICK = 20;
    public static final int SPAWN_COUNT_DATA = 7;
    public static final String SPAWN_COUNT_TAG = "SpawnCount";
    public static final int SPAWN_RANGE_DATA = 3;
    public static final String SPAWN_RANGE_TAG = "SpawnRange";
    public static final String UUID_TAG = "UUID";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final Random random = new Random();
    protected final NonNullList<ItemStack> items = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    private int delay = 10;
    private int despawnRange = 32;
    private int maxNearbyEntities = 1;
    private int numbersPerSpawnInterval = 1;
    private UUID owner;
    private int requiredPlayerRange = 16;
    private int spawnRange = 2;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> BaseEasyNPCSpawnerBlockEntity.this.f_58858_.m_123341_();
                case 1 -> BaseEasyNPCSpawnerBlockEntity.this.f_58858_.m_123342_();
                case 2 -> BaseEasyNPCSpawnerBlockEntity.this.f_58858_.m_123343_();
                case 5 -> BaseEasyNPCSpawnerBlockEntity.this.delay;
                case 8 -> BaseEasyNPCSpawnerBlockEntity.this.despawnRange;
                case 6 -> BaseEasyNPCSpawnerBlockEntity.this.maxNearbyEntities;
                case 4 -> BaseEasyNPCSpawnerBlockEntity.this.requiredPlayerRange;
                case 7 -> BaseEasyNPCSpawnerBlockEntity.this.numbersPerSpawnInterval;
                case 3 -> BaseEasyNPCSpawnerBlockEntity.this.spawnRange;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 3: {
                    BaseEasyNPCSpawnerBlockEntity.this.spawnRange = value;
                    break;
                }
                case 8: {
                    BaseEasyNPCSpawnerBlockEntity.this.despawnRange = value;
                    break;
                }
                case 4: {
                    BaseEasyNPCSpawnerBlockEntity.this.requiredPlayerRange = value;
                    break;
                }
                case 5: {
                    BaseEasyNPCSpawnerBlockEntity.this.delay = value;
                    break;
                }
                case 6: {
                    BaseEasyNPCSpawnerBlockEntity.this.maxNearbyEntities = value;
                    break;
                }
                case 7: {
                    BaseEasyNPCSpawnerBlockEntity.this.numbersPerSpawnInterval = value;
                    break;
                }
            }
        }

        public int m_6499_() {
            return 9;
        }
    };
    private int spawnTicker = 0;
    private int spawnerTicker = this.random.nextInt(20);
    private UUID spawnerUUID;

    public BaseEasyNPCSpawnerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, BaseEasyNPCSpawnerBlockEntity blockEntity) {
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, BaseEasyNPCSpawnerBlockEntity blockEntity) {
        if (blockEntity.spawnerTicker++ >= 20) {
            if (blockEntity.spawnTicker++ >= blockEntity.delay) {
                BaseEasyNPCSpawnerBlockEntity.despawnTick(level, blockPos, blockState, blockEntity);
                BaseEasyNPCSpawnerBlockEntity.spawnTick(level, blockPos, blockState, blockEntity);
                blockEntity.spawnTicker = 0;
            }
            blockEntity.spawnerTicker = 0;
        }
    }

    public static void despawnTick(Level level, BlockPos blockPos, BlockState blockState, BaseEasyNPCSpawnerBlockEntity blockEntity) {
        if (!blockEntity.checkDespawnConditions()) {
            return;
        }
        log.debug("Despawn tick for {}", (Object)blockEntity);
        Set<EasyNPC<?>> validEasyNPCs = blockEntity.getEasyNPCsInRange(blockEntity.f_58858_, blockEntity.despawnRange);
        Set<EasyNPC<?>> nearbyEasyNPCs = blockEntity.getEasyNPCsInRange(blockEntity.f_58858_, blockEntity.despawnRange + 256);
        for (EasyNPC<?> easyNPC : nearbyEasyNPCs) {
            if (validEasyNPCs.contains(easyNPC)) continue;
            log.debug("Despawn {} from spawner at {} outside of range {}", easyNPC, (Object)blockPos, (Object)blockEntity.despawnRange);
            easyNPC.getEntity().m_146870_();
        }
    }

    public static void spawnTick(Level level, BlockPos blockPos, BlockState blockState, BaseEasyNPCSpawnerBlockEntity blockEntity) {
        if (!blockEntity.checkSpawnConditions()) {
            return;
        }
        log.debug("Spawn tick for {}", (Object)blockEntity);
        BlockPos spawnerBlockPos = BaseEasyNPCSpawnerBlockEntity.getFreeSpawnerBlockPos(blockPos, level);
        ItemStack presetItemStack = blockEntity.getPresetItemStack().m_41777_();
        EasyNPCPresetItem.setSpawnerUUID(presetItemStack, blockEntity.getSpawnerUUID());
        int numbersPerSpawnInterval = blockEntity.getSpawnCount();
        Iterable possibleSpawnPositions = BlockPos.m_121935_((BlockPos)spawnerBlockPos, (int)blockEntity.getSpawnRange(), (Direction)Direction.NORTH, (Direction)Direction.EAST);
        for (BlockPos.MutableBlockPos spawnBlockPos : possibleSpawnPositions) {
            AABB aabb = new AABB((BlockPos)spawnBlockPos).m_82400_(0.1);
            BlockPos targetBlockPos = new BlockPos(spawnBlockPos.m_123341_(), spawnBlockPos.m_123342_(), spawnBlockPos.m_123343_());
            if (!level.m_8055_(targetBlockPos.m_7494_()).m_60795_() || level.m_8055_(targetBlockPos).m_60734_() instanceof BaseEasyNPCSpawnerBlock || !level.m_45976_(LivingEntity.class, aabb).isEmpty() || !EasyNPCPresetItem.spawnAtPosition((BlockPos)spawnBlockPos, presetItemStack, level)) continue;
            if (blockEntity.getSpawnCount() > 0) {
                if (--numbersPerSpawnInterval <= 0) break;
                log.info("Spawned {} ({} / {}) at {} with in {}", (Object)presetItemStack, (Object)numbersPerSpawnInterval, (Object)blockEntity.getSpawnCount(), (Object)spawnBlockPos, (Object)level);
                continue;
            }
            log.info("Spawned {} at {} with in {}", (Object)presetItemStack, (Object)spawnBlockPos, (Object)level);
        }
    }

    public static BlockPos getFreeSpawnerBlockPos(BlockPos blockPos, Level level) {
        for (int yExpand = 0; yExpand < 3; ++yExpand) {
            if (!level.m_8055_(blockPos.m_6630_(yExpand).m_122012_()).m_60795_() && !level.m_8055_(blockPos.m_6630_(yExpand).m_122019_()).m_60795_() && !level.m_8055_(blockPos.m_6630_(yExpand).m_122029_()).m_60795_() && !level.m_8055_(blockPos.m_6630_(yExpand).m_122024_()).m_60795_()) continue;
            return blockPos.m_6630_(yExpand);
        }
        return blockPos;
    }

    public boolean checkDespawnConditions() {
        Level level;
        if (this.getPresetItemStack() == null) {
            return false;
        }
        if (this.despawnRange > 0 && (level = this.m_58904_()) != null) {
            Set<EasyNPC<?>> validEasyNPCs = this.getEasyNPCsInRange(this.f_58858_, this.despawnRange);
            Set<EasyNPC<?>> nearbyEasyNPCs = this.getEasyNPCsInRange(this.f_58858_, this.despawnRange + 256);
            for (EasyNPC<?> easyNPC : nearbyEasyNPCs) {
                if (validEasyNPCs.contains(easyNPC)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkSpawnConditions() {
        Level level;
        if (this.getPresetItemStack() == null) {
            return false;
        }
        if (this.requiredPlayerRange > 0 && (level = this.m_58904_()) != null) {
            boolean isPlayerInRange = false;
            for (Player player : level.m_6907_()) {
                if (!(player.m_20275_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()) <= (double)(this.requiredPlayerRange * this.requiredPlayerRange))) continue;
                isPlayerInRange = true;
                break;
            }
            if (!isPlayerInRange) {
                return false;
            }
        }
        if (this.maxNearbyEntities > 0) {
            Set<EasyNPC<?>> nearbyEasyNPCs = this.getEasyNPCsInRange(this.f_58858_, this.spawnRange);
            return nearbyEasyNPCs.size() < this.maxNearbyEntities;
        }
        return true;
    }

    public ItemStack getPresetItemStack() {
        if (this.items.isEmpty() || ((ItemStack)this.items.get(0)).m_41619_() && !EasyNPCPresetItem.hasPreset((ItemStack)this.items.get(0))) {
            return null;
        }
        return (ItemStack)this.items.get(0);
    }

    public UUID getSpawnerUUID() {
        return this.spawnerUUID;
    }

    public void setSpawnerUUID(UUID spawnerUUID) {
        this.spawnerUUID = spawnerUUID;
        this.m_6596_();
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(LivingEntity livingEntity) {
        this.owner = livingEntity.m_20148_();
        this.m_6596_();
    }

    protected Component m_6820_() {
        return TextComponent.getTranslatedTextRaw("text.easy_npc.container.easy_npc_spawner_entity");
    }

    protected AbstractContainerMenu m_6555_(int containerId, Inventory inventory) {
        return null;
    }

    public int getSpawnRange() {
        return this.dataAccess.m_6413_(3);
    }

    public void setSpawnRange(int spawnRange) {
        this.dataAccess.m_8050_(3, Math.max(0, Math.min(64, spawnRange)));
        this.m_6596_();
    }

    public int getDespawnRange() {
        return this.dataAccess.m_6413_(8);
    }

    public void setDespawnRange(int despawnRange) {
        this.dataAccess.m_8050_(8, Math.max(0, Math.min(128, despawnRange)));
        this.m_6596_();
    }

    public int getRequiredPlayerRange() {
        return this.dataAccess.m_6413_(4);
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        this.dataAccess.m_8050_(4, Math.max(0, Math.min(64, requiredPlayerRange)));
        this.m_6596_();
    }

    public int getDelay() {
        return this.dataAccess.m_6413_(5);
    }

    public void setDelay(int delay) {
        this.dataAccess.m_8050_(5, Math.max(0, Math.min(3600, delay)));
        this.m_6596_();
    }

    public int getMaxNearbyEntities() {
        return this.dataAccess.m_6413_(6);
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        this.dataAccess.m_8050_(6, Math.max(0, Math.min(256, maxNearbyEntities)));
        this.m_6596_();
    }

    public int getSpawnCount() {
        return this.dataAccess.m_6413_(7);
    }

    public void setSpawnCount(int spawnCount) {
        this.dataAccess.m_8050_(7, Math.max(0, Math.min(32, spawnCount)));
        this.m_6596_();
    }

    public Set<EasyNPC<?>> getEasyNPCsInRange(BlockPos blockPos, int range) {
        if (this.f_58857_ == null) {
            return new HashSet();
        }
        HashSet foundEasyNPCs = new HashSet();
        AABB aabb = new AABB(blockPos).m_82400_((double)range);
        for (LivingEntity livingEntity : this.f_58857_.m_45976_(LivingEntity.class, aabb)) {
            EasyNPC easyNPC;
            if (!(livingEntity instanceof EasyNPC) || !(easyNPC = (EasyNPC)livingEntity).getEasyNPCSpawnerData().hasSpawnerUUID() || !easyNPC.getEasyNPCSpawnerData().getSpawnerUUID().equals(this.spawnerUUID)) continue;
            foundEasyNPCs.add(easyNPC);
        }
        return foundEasyNPCs;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack itemStack) {
        ItemStack itemStackFromIndex = (ItemStack)this.items.get(index);
        if (itemStack.m_150930_(itemStackFromIndex.m_41720_())) {
            return;
        }
        this.items.set(index, (Object)itemStack);
    }

    public boolean m_6542_(Player player) {
        Level level = this.f_58857_;
        return level != null && level.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.spawnerUUID = compoundTag.m_128342_(UUID_TAG);
        this.owner = compoundTag.m_128342_(SPAWNER_OWNER_TAG);
        this.spawnRange = compoundTag.m_128451_(SPAWN_RANGE_TAG);
        this.despawnRange = compoundTag.m_128451_(DESPAWN_RANGE_TAG);
        this.requiredPlayerRange = compoundTag.m_128451_(REQUIRED_PLAYER_RANGE_TAG);
        this.delay = compoundTag.m_128451_(DELAY_TAG);
        this.maxNearbyEntities = compoundTag.m_128451_(MAX_NEARBY_ENTITIES_TAG);
        this.numbersPerSpawnInterval = compoundTag.m_128451_(SPAWN_COUNT_TAG);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
    }

    public void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128362_(UUID_TAG, Objects.requireNonNullElseGet(this.spawnerUUID, UUID::randomUUID));
        if (this.owner != null) {
            compoundTag.m_128362_(SPAWNER_OWNER_TAG, this.owner);
        }
        compoundTag.m_128405_(SPAWN_RANGE_TAG, this.spawnRange);
        compoundTag.m_128405_(DESPAWN_RANGE_TAG, this.despawnRange);
        compoundTag.m_128405_(REQUIRED_PLAYER_RANGE_TAG, this.requiredPlayerRange);
        compoundTag.m_128405_(DELAY_TAG, this.delay);
        compoundTag.m_128405_(MAX_NEARBY_ENTITIES_TAG, this.maxNearbyEntities);
        compoundTag.m_128405_(SPAWN_COUNT_TAG, this.numbersPerSpawnInterval);
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
    }
}

