/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import de.markusbordihn.easynpc.client.screen.components.DegreeNumberField;
import de.markusbordihn.easynpc.client.screen.components.PositionNumberField;
import de.markusbordihn.easynpc.client.screen.components.PositiveNumberField;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.ValueUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class RangeSliderButton
extends AbstractWidget {
    public static final Component DECREASE_TEXT = TextComponent.getText("-");
    public static final Component INCREASE_TEXT = TextComponent.getText("+");
    public static final Component RESET_TEXT = TextComponent.getText("\u21ba");
    public static final Component EDIT_TEXT = TextComponent.getText("\u270e");
    public static final Component DONE_TEXT = TextComponent.getText("\u2714");
    private static final int DEFAULT_WIDTH = 170;
    private static final int DEFAULT_HEIGHT = 14;
    private static final int DECREASE_BUTTON_WIDTH = 12;
    private static final int INCREASE_BUTTON_WIDTH = 12;
    private static final int RESET_BUTTON_WIDTH = 12;
    private static final int EDIT_BUTTON_WIDTH = 12;
    private final SliderButton sliderButton;
    private final TextButton textButtonDecrease;
    private final TextButton textButtonIncrease;
    private final TextButton textButtonReset;
    private final TextButton textButtonEdit;
    private final TextButton textButtonDone;
    private final TextField textField;
    private final SliderButton.Type sliderType;
    private final boolean showButtons;

    public RangeSliderButton(int left, int top, String label, double value, double minValue, double maxValue, double defaultValue, double stepSize, SliderButton.OnChange onChange) {
        this(left, top, 170, 14, label, value, minValue, maxValue, defaultValue, stepSize, onChange);
    }

    public RangeSliderButton(int left, int top, int width, int height, double value, double defaultValue, SliderButton.Type sliderType, SliderButton.OnChange onChange) {
        this(left, top, width, height, sliderType.name(), value, SliderButton.getMinValue(sliderType), SliderButton.getMaxValue(sliderType), defaultValue, SliderButton.getStepSize(sliderType), onChange);
    }

    public RangeSliderButton(int left, int top, int width, int height, double value, double defaultValue, SliderButton.Type sliderType, boolean showButtons, SliderButton.OnChange onChange) {
        this(left, top, width, height, sliderType.name(), value, SliderButton.getMinValue(sliderType), SliderButton.getMaxValue(sliderType), defaultValue, SliderButton.getStepSize(sliderType), sliderType, showButtons, onChange);
    }

    public RangeSliderButton(int left, int top, int width, int height, String label, double value, double minValue, double maxValue, double defaultValue, double stepSize, SliderButton.OnChange onChange) {
        this(left, top, width, height, label, value, minValue, maxValue, defaultValue, stepSize, SliderButton.Type.DOUBLE, true, onChange);
    }

    public RangeSliderButton(int left, int top, int width, int height, String label, double value, double minValue, double maxValue, double defaultValue, double stepSize, SliderButton.Type sliderType, boolean showButtons, SliderButton.OnChange onChange) {
        super(left, top, width, height, (Component)TextComponent.getBlankText());
        Font font = Minecraft.m_91087_().f_91062_;
        this.sliderType = sliderType;
        this.showButtons = showButtons;
        this.sliderButton = new SliderButton(this.showButtons ? left + 12 : left, top, this.getDefaultSliderWidth(), height, value, minValue, maxValue, button -> this.updateSliderValue(button, onChange), this.sliderType);
        this.textField = switch (this.sliderType) {
            case SliderButton.Type.DEGREE -> new DegreeNumberField(font, this.showButtons ? left + 12 : left, top, this.getDefaultSliderWidth(), height, value);
            case SliderButton.Type.POSITION -> new PositionNumberField(font, this.showButtons ? left + 12 : left, top, this.getDefaultSliderWidth(), height, value, minValue, maxValue);
            default -> new PositiveNumberField(font, this.showButtons ? left + 12 : left, top, this.getDefaultSliderWidth(), height, value);
        };
        this.textField.m_94151_(text -> {
            if (ValueUtils.isDoubleValue(text, minValue, maxValue)) {
                this.sliderButton.setDefaultValue(Double.parseDouble(text));
            }
        });
        this.textButtonDecrease = new TextButton(this.sliderButton.m_252754_() - 12, top, 12, height, DECREASE_TEXT, button -> {
            if (this.sliderButton.getTargetDoubleValue() - stepSize >= minValue) {
                this.sliderButton.setDefaultValue(this.sliderButton.getTargetDoubleValue() - stepSize);
                this.updateTextField();
            }
        });
        this.textButtonDecrease.f_93623_ = showButtons;
        this.textButtonIncrease = new TextButton(this.sliderButton.m_252754_() + this.sliderButton.m_5711_(), top, 12, height, INCREASE_TEXT, button -> {
            if (this.sliderButton.getTargetDoubleValue() + stepSize <= maxValue) {
                this.sliderButton.setDefaultValue(this.sliderButton.getTargetDoubleValue() + stepSize);
                this.updateTextField();
            }
        });
        this.textButtonIncrease.f_93623_ = showButtons;
        this.textButtonReset = new TextButton(this.textButtonIncrease.m_252754_() + this.textButtonIncrease.m_5711_(), top, 12, height, RESET_TEXT, button -> {
            this.sliderButton.setDefaultValue(defaultValue);
            this.updateTextField();
        });
        this.textButtonReset.f_93623_ = showButtons;
        this.textButtonEdit = new TextButton(this.textButtonReset.m_252754_() + this.textButtonReset.m_5711_(), top, 12, height, EDIT_TEXT, this::showTextField);
        this.textButtonEdit.f_93623_ = showButtons;
        this.textButtonDone = new TextButton(this.textButtonReset.m_252754_() + this.textButtonReset.m_5711_(), top, 12, height, DONE_TEXT, this::showSliderButton);
        this.textButtonDone.f_93623_ = showButtons;
    }

    public void reset() {
        this.sliderButton.reset();
        this.updateTextField();
    }

    public int getDefaultSliderWidth() {
        if (this.showButtons) {
            return this.f_93618_ - 48;
        }
        return this.f_93618_;
    }

    private void updateSliderValue(SliderButton sliderButton, SliderButton.OnChange onChange) {
        onChange.onChange(sliderButton);
    }

    private void updateTextField() {
        String sliderValue;
        switch (this.sliderType) {
            case DEGREE: {
                String string = String.format("%.1f", this.sliderButton.getTargetDoubleValue()).replace(",", ".");
                break;
            }
            default: {
                String string = sliderValue = String.format("%.2f", this.sliderButton.getTargetDoubleValue()).replace(",", ".");
            }
        }
        if (!this.textField.m_94155_().equals(sliderValue)) {
            this.textField.m_94144_(sliderValue);
        }
    }

    public void showTextField() {
        this.showTextField(null);
    }

    public void showSliderButton() {
        this.showSliderButton(null);
    }

    private void showTextField(Button button) {
        this.updateTextField();
        this.sliderButton.f_93624_ = false;
        this.sliderButton.m_93692_(false);
        this.textButtonEdit.f_93624_ = false;
        this.textButtonDone.f_93624_ = true;
        this.textField.f_93624_ = true;
    }

    private void showSliderButton(Button button) {
        this.sliderButton.f_93624_ = true;
        this.textButtonEdit.f_93624_ = true;
        this.textButtonDone.f_93624_ = false;
        this.textField.f_93624_ = false;
        this.textField.m_93692_(false);
    }

    public float getTargetValue() {
        return this.sliderButton.getTargetValue();
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.sliderButton.isVisible()) {
            this.sliderButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        } else if (this.textField.m_94213_()) {
            this.textField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.textButtonDecrease.m_142518_()) {
            this.textButtonDecrease.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.textButtonIncrease.m_142518_()) {
            this.textButtonIncrease.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.textButtonReset.m_142518_()) {
            this.textButtonReset.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.textButtonEdit.m_142518_() && this.textButtonEdit.isVisible()) {
            this.textButtonEdit.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        } else if (this.textButtonDone.m_142518_() && this.textButtonDone.isVisible()) {
            this.textButtonDone.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.sliderButton.isVisible() && this.sliderButton.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.textField.m_94213_() && this.textField.m_6375_(mouseX, mouseY, button)) {
            this.textField.m_93692_(true);
            return true;
        }
        this.textButtonDecrease.m_6375_(mouseX, mouseY, button);
        this.textButtonIncrease.m_6375_(mouseX, mouseY, button);
        this.textButtonReset.m_6375_(mouseX, mouseY, button);
        if (this.textButtonEdit.isVisible()) {
            this.textButtonEdit.m_6375_(mouseX, mouseY, button);
        } else if (this.textButtonDone.isVisible()) {
            this.textButtonDone.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.textField.m_94213_()) {
            this.textField.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double x, double y, double distance) {
        if (this.sliderButton.isVisible()) {
            this.sliderButton.m_6050_(x, y, distance);
        } else if (this.textField.m_94213_()) {
            this.textField.m_6050_(x, y, distance);
        }
        return super.m_6050_(x, y, distance);
    }

    public void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.sliderButton.isVisible() && this.sliderButton.m_5953_(mouseX, mouseY)) {
            this.sliderButton.triggerOnDrag(mouseX, mouseY, deltaX, deltaY);
        }
    }

    public boolean m_5534_(char character, int keyCode) {
        if (this.sliderButton.isVisible()) {
            return this.sliderButton.m_5534_(character, keyCode);
        }
        if (this.textField.m_94213_()) {
            return this.textField.m_5534_(character, keyCode);
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int unused1, int unused2) {
        if (this.sliderButton.isVisible()) {
            return this.sliderButton.m_7933_(keyCode, unused1, unused2);
        }
        if (this.textField.m_94213_()) {
            return this.textField.m_7933_(keyCode, unused1, unused2);
        }
        return false;
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
        if (this.f_93623_) {
            String usageKey = this.m_93696_() ? "narration.slider.usage.focused" : "narration.slider.usage.hovered";
            narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)TextComponent.getTranslatedTextRaw(usageKey));
        }
    }
}

