/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.pose;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.RangeSliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.configuration.pose.PoseConfigurationScreen;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class CustomPoseConfigurationScreen<T extends ConfigurationMenu>
extends PoseConfigurationScreen<T> {
    protected RangeSliderButton headSliderButton;
    protected RangeSliderButton bodySliderButton;
    protected RangeSliderButton armsSliderButton;
    protected RangeSliderButton leftArmSliderButton;
    protected RangeSliderButton rightArmSliderButton;
    protected RangeSliderButton leftLegSliderButton;
    protected RangeSliderButton rightLegSliderButton;

    public CustomPoseConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private RangeSliderButton createVisibilityRotationPositionSlider(int left, int top, ModelPart modelPart, String label) {
        RangeSliderButton sliderRotationButtonX = this.createRotationSlider(left, top, modelPart, label);
        RangeSliderButton sliderPositionButtonX = this.createPositionSliderCompact(left, top + sliderRotationButtonX.m_93694_(), modelPart, label);
        boolean modelPartVisibility = this.modelData.isModelPartVisible(modelPart);
        this.m_142416_((GuiEventListener)new Checkbox(sliderRotationButtonX.m_252754_() + 3, top - sliderPositionButtonX.m_93694_(), "", modelPartVisibility, checkbox -> NetworkMessageHandlerManager.getServerHandler().modelVisibilityChange(this.getEasyNPCUUID(), modelPart, checkbox.selected())));
        return sliderRotationButtonX;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.customPoseButton.f_93623_ = false;
        int sliderTopPos = this.contentTopPos + 56;
        int sliderLeftPos = this.contentLeftPos - 3;
        int sliderLeftSpace = 200;
        int sliderTopSpace = 60;
        VariantData<?> variantData = this.getEasyNPC().getEasyNPCVariantData();
        boolean hasCrossedArms = variantData.hasVariantCrossedArms();
        if (this.modelData.hasHeadModelPart()) {
            this.headSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos, sliderTopPos, ModelPart.HEAD, "head");
        }
        if (this.modelData.hasBodyModelPart()) {
            this.bodySliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.BODY, "body");
        }
        sliderTopPos += sliderTopSpace;
        if (hasCrossedArms || !this.modelData.hasLeftArmModelPart() && !this.modelData.hasRightArmModelPart() && this.modelData.hasArmsModelPart()) {
            sliderLeftPos = this.contentLeftPos - 3;
            this.armsSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos, sliderTopPos, ModelPart.ARMS, "arms");
        }
        if (!hasCrossedArms && this.modelData.hasRightArmModelPart()) {
            sliderLeftPos = this.contentLeftPos - 3;
            this.rightArmSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos, sliderTopPos, ModelPart.RIGHT_ARM, "right_arm");
        }
        if (!hasCrossedArms && this.modelData.hasLeftArmModelPart()) {
            this.leftArmSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.LEFT_ARM, "left_arm");
        }
        sliderTopPos += sliderTopSpace;
        if (this.modelData.hasRightLegModelPart()) {
            sliderLeftPos = this.contentLeftPos - 3;
            this.rightLegSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos, sliderTopPos, ModelPart.RIGHT_LEG, "right_leg");
        }
        if (this.modelData.hasLeftLegModelPart()) {
            this.leftLegSliderButton = this.createVisibilityRotationPositionSlider(sliderLeftPos += sliderLeftSpace, sliderTopPos, ModelPart.LEFT_LEG, "left_leg");
        }
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        ScreenHelper.renderCustomPoseEntityAvatar(this.contentLeftPos + 157, this.contentTopPos + 165, 45, (float)(this.contentLeftPos + 150) - this.xMouse, (float)(this.contentTopPos + 100) - this.yMouse, this.getEasyNPC());
        if (this.modelData.hasHeadModelPart() && this.headSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "pose.head", this.headSliderButton.m_252754_() + 20, this.headSliderButton.m_252907_() - 12);
        }
        if (this.modelData.hasBodyModelPart() && this.bodySliderButton != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "pose.body", this.bodySliderButton.m_252754_() + 20, this.bodySliderButton.m_252907_() - 12);
        }
        if (this.modelData.hasLeftArmModelPart() && this.leftArmSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "pose.left_arm", this.leftArmSliderButton.m_252754_() + 20, this.leftArmSliderButton.m_252907_() - 12);
        } else if (this.modelData.hasArmsModelPart() && this.armsSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "pose.arms", this.armsSliderButton.m_252754_() + 20, this.armsSliderButton.m_252907_() - 12);
        }
        if (this.modelData.hasRightArmModelPart() && this.rightArmSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "pose.right_arm", this.rightArmSliderButton.m_252754_() + 20, this.rightArmSliderButton.m_252907_() - 12);
        }
        if (this.modelData.hasLeftLegModelPart() && this.leftLegSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "pose.left_leg", this.leftLegSliderButton.m_252754_() + 20, this.leftLegSliderButton.m_252907_() - 12);
        }
        if (this.modelData.hasRightLegModelPart() && this.rightLegSliderButton != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "pose.right_leg", this.rightLegSliderButton.m_252754_() + 20, this.rightLegSliderButton.m_252907_() - 12);
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        int backgroundTopPos = this.contentTopPos + 30;
        guiGraphics.m_280509_(this.contentLeftPos + 109, backgroundTopPos, this.contentLeftPos + 206, this.contentTopPos + 178, -16777216);
        guiGraphics.m_280509_(this.contentLeftPos + 110, backgroundTopPos + 1, this.contentLeftPos + 205, this.contentTopPos + 177, -5592406);
    }
}

