/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.preset;

import de.markusbordihn.easynpc.client.screen.configuration.preset.ImportPresetConfigurationScreen;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ImportWorldPresetConfigurationScreen<T extends ConfigurationMenu>
extends ImportPresetConfigurationScreen<T> {
    private final Set<ResourceLocation> worldPresets;

    public ImportWorldPresetConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.importPresetButtonLabel = "import_world_preset";
        this.importPresetHeaderLabel = "preset_world_for";
        this.worldPresets = CompoundTagUtils.readResourceLocations(this.getAdditionalScreenData().getList("WorldPresets")).stream().filter(resourceLocation -> resourceLocation.m_135815_().contains("/" + this.getSkinModel().getName() + "/")).collect(Collectors.toSet());
    }

    @Override
    public void loadPreset(ResourceLocation resourceLocation) {
        NetworkMessageHandlerManager.getServerHandler().importWorldPreset(this.getEasyNPCUUID(), resourceLocation);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.worldImportPresetButton.f_93623_ = false;
        ImportPresetConfigurationScreen.updatePresets(this.worldPresets.stream().toList());
        this.presetSelectionList.updatePresets();
    }
}

