/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.editor.dialog;

import de.markusbordihn.easynpc.client.screen.EditorScreen;
import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButtonButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.SpriteButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextEditButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class DialogEditorScreen<T extends EditorMenu>
extends EditorScreen<T> {
    private static final int MAX_NUMBER_OF_BUTTONS = 6;
    protected Button homeButton;
    protected Button dialogButton;
    protected Button dialogTextButton;
    protected Button addDialogButton;
    protected Button saveButton;
    protected Button cancelButton;
    protected Button deleteButton;
    protected TextField dialogLabelTextField;
    protected Checkbox dialogLabelCheckbox;
    protected Button dialogNameToLabelButton;
    protected Button makeDefaultDialogButton;
    protected TextField dialogNameTextField;
    private String dialogLabelValue = "";
    private String dialogNameValue = "";

    public DialogEditorScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void refreshScreen() {
        NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID());
    }

    private void openPreviousScreen() {
        NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DIALOG);
    }

    private void deleteDialog() {
        Minecraft minecraft = this.f_96541_;
        if (minecraft == null) {
            return;
        }
        minecraft.m_91152_((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed && this.getEasyNPCUUID() != null) {
                NetworkMessageHandlerManager.getServerHandler().removeDialog(this.getEasyNPCUUID(), this.getDialogUUID());
                NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DIALOG);
            } else {
                minecraft.m_91152_((Screen)this);
            }
        }, (Component)TextComponent.getTranslatedText("removeDialog.deleteQuestion"), (Component)TextComponent.getTranslatedText("removeDialog.deleteWarning", this.getDialogData().getName()), (Component)TextComponent.getTranslatedText("removeDialog.deleteButton"), CommonComponents.f_130656_));
    }

    private void renderEditLabels(GuiGraphics guiGraphics) {
        if (this.dialogNameTextField != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "dialog.name", this.leftPos + 10, this.dialogNameTextField.m_252907_() + 4, 0);
        }
        if (this.dialogLabelTextField != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "label_id", this.leftPos + 10, this.dialogLabelTextField.m_252907_() + 4, 0);
        }
        if (this.dialogTextButton != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "dialog.text", this.leftPos + 10, this.dialogTextButton.m_252907_() - 13, 0);
            Text.drawConfigString(guiGraphics, this.f_96547_, "dialog.buttons", this.leftPos + 10, this.dialogTextButton.m_252907_() + 27, 0);
        }
    }

    private void makeDefaultDialog() {
        if (this.getDialogUUID().equals(this.getDialogDataSet().getDefaultDialogId())) {
            return;
        }
        DialogDataSet dialogDataSet = this.getDialogDataSet();
        dialogDataSet.setDefaultDialog(this.getDialogUUID());
        NetworkMessageHandlerManager.getServerHandler().saveDialogSet(this.getEasyNPCUUID(), dialogDataSet);
    }

    private void saveDialogData() {
        boolean hasChanged;
        boolean bl = hasChanged = !this.dialogNameTextField.m_94155_().equals(this.dialogNameValue) || !this.dialogLabelTextField.m_94155_().equals(this.dialogLabelValue);
        if (!hasChanged) {
            return;
        }
        DialogDataEntry dialogDataEntry = this.getDialogData();
        dialogDataEntry.setName(this.dialogNameTextField.m_94155_());
        dialogDataEntry.setLabel(this.dialogLabelTextField.m_94155_());
        NetworkMessageHandlerManager.getServerHandler().saveDialog(this.getEasyNPCUUID(), this.getDialogUUID(), dialogDataEntry);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.homeButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.leftPos + 7, this.topPos + 7, 10, 18, "<", onPress -> this.openPreviousScreen()));
        this.saveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.leftPos + 25, this.bottomPos - 35, 85, "save", onPress -> {
            this.saveDialogData();
            this.openPreviousScreen();
        }));
        this.deleteButton = (Button)this.m_142416_((GuiEventListener)new DeleteButton(this.saveButton.m_252754_() + this.saveButton.m_5711_() + 10, this.bottomPos - 35, 85, onPress -> this.deleteDialog()));
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)new CancelButton(this.deleteButton.m_252754_() + this.deleteButton.m_5711_() + 10, this.bottomPos - 35, 85, "cancel", onPress -> this.openPreviousScreen()));
        DialogDataEntry dialogDataEntry = this.getDialogData();
        this.dialogButton = (Button)this.m_142416_((GuiEventListener)new DialogButton(this.homeButton.m_252754_() + this.homeButton.m_5711_(), this.topPos + 7, 140, dialogDataEntry.getName(21), onPress -> {}));
        this.dialogButton.f_93623_ = false;
        this.dialogNameValue = this.getDialogData().getName();
        this.dialogNameTextField = new TextField(this.f_96547_, this.leftPos + 100, this.topPos + 30, 150, this.dialogNameValue);
        this.dialogNameTextField.m_94199_(64);
        this.m_142416_((GuiEventListener)this.dialogNameTextField);
        this.dialogNameToLabelButton = (Button)this.m_142416_((GuiEventListener)new SpriteButton(this.dialogNameTextField.m_252754_() + this.dialogNameTextField.m_5711_() + 1, this.dialogNameTextField.m_252907_() - 1, 18, 18, 4, 4, 80, 80, 12, 12, onPress -> {
            if (this.dialogNameTextField != null && this.dialogLabelTextField != null) {
                String buttonName = this.dialogNameTextField.m_94155_();
                this.dialogLabelTextField.m_94144_(DialogUtils.generateButtonLabel(buttonName));
            }
        }));
        this.makeDefaultDialogButton = (Button)this.m_142416_((GuiEventListener)new SpriteButton(this.dialogNameToLabelButton.m_252754_() + this.dialogNameToLabelButton.m_5711_() + 1, this.dialogNameToLabelButton.m_252907_(), 30, 18, 2, 2, 92, 128, 25, 12, onPress -> {
            this.makeDefaultDialog();
            this.refreshScreen();
        }));
        this.dialogLabelValue = dialogDataEntry.getLabel();
        this.dialogLabelTextField = new TextField(this.f_96547_, this.leftPos + 100, this.topPos + 50, 100);
        this.dialogLabelTextField.m_94199_(32);
        this.dialogLabelTextField.m_94144_(this.dialogLabelValue);
        this.dialogLabelTextField.m_94186_(this.dialogLabelTextField.m_94155_().isEmpty());
        this.m_142416_((GuiEventListener)this.dialogLabelTextField);
        this.dialogLabelCheckbox = new Checkbox(this.leftPos + 203, this.dialogLabelTextField.m_252907_() + 1, "locked", !dialogDataEntry.getLabel().isEmpty(), checkbox -> this.dialogLabelTextField.m_94186_(!checkbox.selected()));
        this.m_142416_((GuiEventListener)this.dialogLabelCheckbox);
        this.dialogTextButton = (Button)this.m_142416_((GuiEventListener)new TextEditButton(this.leftPos + 7, this.topPos + 105, 303, "dialog.edit_text", onPress -> {
            this.saveDialogData();
            NetworkMessageHandlerManager.getServerHandler().openDialogTextEditor(this.getEasyNPCUUID(), this.getDialogUUID());
        }));
        this.defineDialogButtons(dialogDataEntry);
    }

    private void defineDialogButtons(DialogDataEntry dialogDataEntry) {
        Set<DialogButtonEntry> dialogButtons = dialogDataEntry.getDialogButtons();
        boolean smallButtons = dialogButtons.size() < 4;
        int buttonIndex = 0;
        int buttonBaseLeftPos = this.leftPos + 7;
        int buttonTopPos = this.topPos + 145;
        int buttonLeftPos = buttonBaseLeftPos;
        int buttonSpace = 3;
        int buttonWidth = smallButtons ? 150 : 100;
        int buttonMaxTextLength = smallButtons ? 22 : 14;
        for (DialogButtonEntry dialogButtonEntry : dialogButtons) {
            if (buttonIndex > 5) break;
            if (smallButtons && buttonIndex == 2 || !smallButtons && buttonIndex == 3) {
                buttonTopPos += 20;
                buttonLeftPos = buttonBaseLeftPos;
            }
            DialogButtonButton dialogActionButton = new DialogButtonButton(buttonLeftPos, buttonTopPos, buttonWidth, dialogButtonEntry.getButtonName(buttonMaxTextLength).getString(), onPress -> {
                log.info("Edit dialog button {}", (Object)dialogButtonEntry.id());
                NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), this.getDialogUUID(), dialogButtonEntry.id());
            });
            this.m_142416_((GuiEventListener)dialogActionButton);
            buttonLeftPos += buttonWidth + buttonSpace;
            ++buttonIndex;
        }
        if (buttonIndex < 6) {
            this.addDialogButton = new AddButton(dialogButtons.size() < 5 && buttonIndex != 2 ? buttonLeftPos : buttonBaseLeftPos, dialogButtons.size() < 5 && buttonIndex != 2 ? buttonTopPos : buttonTopPos + 20, smallButtons ? buttonWidth : 150, "dialog.add_button", onPress -> {
                this.saveDialogData();
                NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), this.getDialogUUID());
            });
            this.m_142416_((GuiEventListener)this.addDialogButton);
        }
    }

    @Override
    public void updateTick() {
        super.updateTick();
        if (this.saveButton != null) {
            boolean bl = this.saveButton.f_93623_ = !this.dialogNameTextField.m_94155_().equals(this.dialogNameValue) || !this.dialogLabelTextField.m_94155_().equals(this.dialogLabelValue);
        }
        if (this.dialogLabelCheckbox != null && this.dialogNameToLabelButton != null) {
            boolean bl = this.dialogNameToLabelButton.f_93623_ = !this.dialogLabelCheckbox.selected();
        }
        if (this.makeDefaultDialogButton != null && this.getDialogDataSet() != null) {
            this.makeDefaultDialogButton.f_93623_ = !this.getDialogUUID().equals(this.getDialogDataSet().getDefaultDialogId());
        }
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, x, y, partialTicks);
        this.renderEditLabels(guiGraphics);
        if (this.dialogNameToLabelButton != null && this.dialogNameToLabelButton.m_5953_((double)x, (double)y)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)TextComponent.getTranslatedConfigText("name_to_label.tooltip"), x, y);
        }
        if (this.makeDefaultDialogButton != null && this.makeDefaultDialogButton.m_5953_((double)x, (double)y)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)TextComponent.getTranslatedConfigText("make_default.tooltip"), x, y);
        }
    }
}

