/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.display;

import de.markusbordihn.easynpc.data.display.DisplayAttributeEntry;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import java.util.HashSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DisplayAttributeSet {
    public static final String DATA_DISPLAY_ATTRIBUTE_SET_TAG = "DisplayAttributeSet";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private final HashSet<DisplayAttributeEntry> displayAttributeEntrySet = new HashSet();

    public DisplayAttributeSet() {
        this.addDisplayAttribute(DisplayAttributeType.LIGHT_LEVEL, 7);
        this.addDisplayAttribute(DisplayAttributeType.VISIBLE, true);
        this.addDisplayAttribute(DisplayAttributeType.VISIBLE_AT_DAY, true);
        this.addDisplayAttribute(DisplayAttributeType.VISIBLE_AT_NIGHT, true);
        this.addDisplayAttribute(DisplayAttributeType.VISIBLE_IN_CREATIVE, true);
        this.addDisplayAttribute(DisplayAttributeType.VISIBLE_IN_SPECTATOR, true);
        this.addDisplayAttribute(DisplayAttributeType.VISIBLE_IN_STANDARD, true);
        this.addDisplayAttribute(DisplayAttributeType.VISIBLE_TO_OWNER, true);
        this.addDisplayAttribute(DisplayAttributeType.VISIBLE_TO_TEAM, true);
    }

    public DisplayAttributeSet(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public void addDisplayAttribute(DisplayAttributeType displayAttributeType, boolean booleanValue, int intValue) {
        this.displayAttributeEntrySet.add(new DisplayAttributeEntry(displayAttributeType, booleanValue, intValue));
    }

    public void addOrReplaceDisplayAttribute(DisplayAttributeEntry displayAttributeEntry) {
        this.displayAttributeEntrySet.removeIf(entry -> entry.displayAttributeType().equals((Object)displayAttributeEntry.displayAttributeType()));
        this.displayAttributeEntrySet.add(displayAttributeEntry);
    }

    public void addDisplayAttribute(DisplayAttributeType displayAttributeType, boolean booleanValue) {
        this.addDisplayAttribute(displayAttributeType, booleanValue, 0);
    }

    public void addDisplayAttribute(DisplayAttributeType displayAttributeType, int intValue) {
        this.addDisplayAttribute(displayAttributeType, false, intValue);
    }

    public boolean hasDisplayAttribute(DisplayAttributeType displayAttributeType) {
        return this.displayAttributeEntrySet.stream().anyMatch(entry -> entry.displayAttributeType().equals((Object)displayAttributeType));
    }

    public boolean getBooleanValue(DisplayAttributeType displayAttributeType) {
        return this.displayAttributeEntrySet.stream().filter(entry -> entry.displayAttributeType().equals((Object)displayAttributeType)).map(DisplayAttributeEntry::booleanValue).findFirst().orElse(false);
    }

    public int getIntValue(DisplayAttributeType displayAttributeType) {
        return this.displayAttributeEntrySet.stream().filter(entry -> entry.displayAttributeType().equals((Object)displayAttributeType)).map(DisplayAttributeEntry::intValue).findFirst().orElse(0);
    }

    public CompoundTag save(CompoundTag compoundTag) {
        ListTag displayListTag = new ListTag();
        this.displayAttributeEntrySet.stream().filter(entry -> entry.displayAttributeType() != DisplayAttributeType.NONE).forEach(entry -> displayListTag.add((Object)entry.write(new CompoundTag())));
        compoundTag.m_128365_(DATA_DISPLAY_ATTRIBUTE_SET_TAG, (Tag)displayListTag);
        return compoundTag;
    }

    public void load(CompoundTag compoundTag) {
        if (compoundTag == null || !compoundTag.m_128441_(DATA_DISPLAY_ATTRIBUTE_SET_TAG)) {
            return;
        }
        ListTag displayListTag = compoundTag.m_128437_(DATA_DISPLAY_ATTRIBUTE_SET_TAG, 10);
        displayListTag.forEach(entry -> {
            if (entry instanceof CompoundTag) {
                CompoundTag entryCompoundTag = (CompoundTag)entry;
                DisplayAttributeEntry displayAttributeEntry = new DisplayAttributeEntry(entryCompoundTag);
                if (displayAttributeEntry.displayAttributeType() != DisplayAttributeType.NONE) {
                    this.displayAttributeEntrySet.add(displayAttributeEntry);
                } else {
                    log.warn("Skip invalid display attribute entry {}", (Object)displayAttributeEntry);
                }
            } else {
                log.error("Failed to load display attribute entry from {}", entry);
            }
        });
    }

    public CompoundTag createTag() {
        return this.save(new CompoundTag());
    }

    public String toString() {
        return "DisplayDataSet{displayAttributeSet=" + this.displayAttributeEntrySet + "}";
    }
}

