/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.attribute.CustomAttributes;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public interface CustomAttributeData<E extends PathfinderMob>
extends EasyNPC<E> {
    public static void registerSyncedCustomAttributeData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Custom Attribute Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.CUSTOM_ATTRIBUTES, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.CUSTOM_ATTRIBUTES));
    }

    default public void defineSynchedCustomAttributeData() {
        this.defineSynchedEntityData(SynchedDataIndex.CUSTOM_ATTRIBUTES, new CustomAttributes());
    }

    default public CustomAttributes getCustomAttributes() {
        return (CustomAttributes)this.getSynchedEntityData(SynchedDataIndex.CUSTOM_ATTRIBUTES);
    }

    default public void setCustomAttributes(CustomAttributes customAttributes) {
        this.setSynchedEntityData(SynchedDataIndex.CUSTOM_ATTRIBUTES, customAttributes);
    }

    default public void addAdditionalCustomAttributeData(CompoundTag compoundTag) {
        CustomAttributes customAttributes = this.getCustomAttributes();
        customAttributes.save(compoundTag);
    }

    default public void readAdditionalCustomAttributeData(CompoundTag compoundTag) {
        this.setCustomAttributes(new CustomAttributes(compoundTag));
    }
}

