/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.server.ServerDataAccessor;
import de.markusbordihn.easynpc.data.server.ServerDataIndex;
import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.PathfinderMob;

public interface SpawnerData<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final ServerDataAccessor<UUID> CUSTOM_DATA_SPAWNER_UUID = ServerEntityData.defineId(ServerDataIndex.SPAWNER_UUID, EntityDataSerializersManager.UUID);
    public static final String DATA_SPAWNER_UUID_TAG = "SpawnerUUID";

    default public boolean hasSpawnerUUID() {
        return this.getSpawnerUUID() != null;
    }

    default public UUID getSpawnerUUID() {
        return this.getEasyNPCServerData().getServerEntityData(CUSTOM_DATA_SPAWNER_UUID);
    }

    default public void setSpawnerUUID(UUID uuid) {
        this.getEasyNPCServerData().setServerEntityData(CUSTOM_DATA_SPAWNER_UUID, uuid);
    }

    default public void defineCustomSpawnerData() {
        this.getEasyNPCServerData().defineServerEntityData(CUSTOM_DATA_SPAWNER_UUID, null);
    }

    default public void addAdditionalSpawnerData(CompoundTag compoundTag) {
        if (this.isServerSide() && this.getSpawnerUUID() != null) {
            compoundTag.m_128362_(DATA_SPAWNER_UUID_TAG, this.getSpawnerUUID());
        }
    }

    default public void readAdditionalSpawnerData(CompoundTag compoundTag) {
        if (compoundTag.m_128403_(DATA_SPAWNER_UUID_TAG)) {
            this.setSpawnerUUID(compoundTag.m_128342_(DATA_SPAWNER_UUID_TAG));
        }
    }
}

