/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers;

import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeData;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import java.util.Objects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.Team;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VisibilityHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    private VisibilityHandler() {
    }

    public static boolean handleIsInvisible(EasyNPC<?> easyNPC, boolean isInvisible) {
        DisplayAttributeData<?> displayAttributeData = easyNPC.getEasyNPCDisplayAttributeData();
        if (displayAttributeData != null && displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE) && !displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE)) {
            return true;
        }
        return isInvisible;
    }

    public static boolean handleIsInvisibleToPlayer(EasyNPC<?> easyNPC, Player player, boolean isInvisibleToPlayers) {
        DisplayAttributeData<?> displayAttributeData = easyNPC.getEasyNPCDisplayAttributeData();
        if (displayAttributeData == null) {
            return isInvisibleToPlayers;
        }
        if (displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE) && !displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE)) {
            return true;
        }
        boolean isVisible = true;
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        long dayTime = player.m_9236_().m_46468_() % 24000L;
        if (displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_AT_DAY) && !displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_AT_DAY) && dayTime >= 1000L && dayTime <= 13000L) {
            isVisible = false;
        }
        if (displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_AT_NIGHT) && !displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_AT_NIGHT) && (dayTime < 1000L || dayTime > 13000L)) {
            isVisible = false;
        }
        if (displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_IN_CREATIVE) && !displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_IN_CREATIVE) && player.m_7500_()) {
            isVisible = false;
        }
        if (displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_IN_SPECTATOR) && !displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_IN_SPECTATOR) && player.m_5833_()) {
            isVisible = false;
        }
        if (displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_IN_STANDARD) && !displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_IN_STANDARD) && !player.m_7500_() && !player.m_5833_()) {
            isVisible = false;
        }
        OwnerData<?> ownerData = easyNPC.getEasyNPCOwnerData();
        if (displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_TO_OWNER) && displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_TO_OWNER) && ownerData != null && ownerData.hasOwner() && Objects.equals(ownerData.m_21805_(), player.m_20148_())) {
            isVisible = true;
        }
        Team playerTeam = player.m_5647_();
        Team livingEntityTeam = livingEntity.m_5647_();
        if (displayAttributeData.hasDisplayAttribute(DisplayAttributeType.VISIBLE_TO_TEAM) && displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE_TO_TEAM) && livingEntityTeam != null && livingEntityTeam.equals(playerTeam)) {
            isVisible = livingEntityTeam.m_6259_();
        }
        return !isVisible;
    }
}

