/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.EasyNPCBaseModelEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class Piglin
extends EasyNPCBaseModelEntity<Piglin> {
    public static final String ID = "piglin";
    public static final String ID_BRUTE = "piglin_brute";
    public static final String ID_ZOMBIFIED = "piglin_zombified";

    public Piglin(EntityType<? extends PathfinderMob> entityType, Level level) {
        this(entityType, level, Variant.PIGLIN);
    }

    public Piglin(EntityType<? extends PathfinderMob> entityType, Level level, Enum<?> variant) {
        super(entityType, level, variant);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22283_, 0.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22285_, 0.0);
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.PIGLIN;
    }

    @Override
    public Enum<?>[] getVariants() {
        return Variant.values();
    }

    @Override
    public Enum<?> getDefaultVariant() {
        return Variant.PIGLIN;
    }

    @Override
    public Enum<?> getVariant(String name) {
        try {
            return Variant.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultVariant();
        }
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        Variant soundVariant = Variant.valueOf(variantName);
        switch (soundVariant) {
            case PIGLIN_BRUTE: {
                soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.f_12301_);
                soundDataSet.addSound(SoundType.HURT, SoundEvents.f_12304_);
                soundDataSet.addSound(SoundType.DEATH, SoundEvents.f_12303_);
                soundDataSet.addSound(SoundType.STEP, SoundEvents.f_12305_);
                break;
            }
            case ZOMBIFIED_PIGLIN: {
                soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.f_12610_);
                soundDataSet.addSound(SoundType.HURT, SoundEvents.f_12613_);
                soundDataSet.addSound(SoundType.DEATH, SoundEvents.f_12612_);
                soundDataSet.addSound(SoundType.STEP, SoundEvents.f_12299_);
                break;
            }
            default: {
                soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.f_12239_);
                soundDataSet.addSound(SoundType.HURT, SoundEvents.f_12244_);
                soundDataSet.addSound(SoundType.DEATH, SoundEvents.f_12242_);
                soundDataSet.addSound(SoundType.STEP, SoundEvents.f_12299_);
            }
        }
        soundDataSet.addSound(SoundType.TRADE, SoundEvents.f_12508_);
        soundDataSet.addSound(SoundType.TRADE_YES, SoundEvents.f_12509_);
        soundDataSet.addSound(SoundType.TRADE_NO, SoundEvents.f_12507_);
        return soundDataSet;
    }

    public static enum Variant {
        PIGLIN,
        PIGLIN_BRUTE,
        ZOMBIFIED_PIGLIN;

    }
}

