/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import de.markusbordihn.easynpc.validator.NameValidator;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.GameProfileCache;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayersUtils {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final String TEXTURES_STRING = "textures";
    private static final String SESSION_PROFILE_URL = "https://sessionserver.mojang.com/session/minecraft/profile/%s";
    private static final String API_PROFILE_URL = "https://api.mojang.com/users/profiles/minecraft/%s";
    private static final Map<String, UUID> userUUIDCache = new HashMap<String, UUID>();
    private static UUID lastUserUUIDForUserTexture;

    protected PlayersUtils() {
    }

    public static Optional<GameProfile> getGameProfile(MinecraftServer server, String username) {
        if (server == null || username == null || username.isEmpty()) {
            return Optional.empty();
        }
        GameProfileCache gameProfileCache = server.m_129927_();
        return gameProfileCache.m_10996_(username);
    }

    public static UUID getUserUUID(MinecraftServer server, String username) {
        UUID uuid = PlayersUtils.getUUIDfromString(username);
        if (uuid != null) {
            return uuid;
        }
        return PlayersUtils.getGameProfile(server, username).map(GameProfile::getId).map(UUID::toString).map(PlayersUtils::getUUIDfromString).orElse(null);
    }

    public static UUID getUUIDfromString(String uuidString) {
        try {
            return UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static UUID getUserUUID(String username) {
        if (username == null || username.isEmpty() || !NameValidator.isValidPlayerName(username)) {
            log.error("Unable to get user UUID with invalid username: {}", (Object)username);
            return null;
        }
        if (userUUIDCache.containsKey(username)) {
            return userUUIDCache.get(username);
        }
        try {
            String url = String.format(API_PROFILE_URL, username);
            String json = IOUtils.toString((URL)new URL(url), (Charset)StandardCharsets.UTF_8);
            JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
            String uuidString = jsonObject.get("id").getAsString();
            if (uuidString == null || uuidString.isEmpty()) {
                log.error("Unable to get user UUID with invalid response: {}", (Object)json);
                return null;
            }
            String formattedUUID = uuidString.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5");
            UUID userUUID = UUID.fromString(formattedUUID);
            log.debug("Found user {} with UUID {} ...", (Object)username, (Object)userUUID);
            userUUIDCache.put(username, userUUID);
            return userUUID;
        }
        catch (IOException e) {
            log.error("Unable to get UUID from user {}:", (Object)username, (Object)e);
            userUUIDCache.put(username, null);
            return null;
        }
    }

    public static String getUserTexture(UUID userUUID) {
        if (lastUserUUIDForUserTexture != null && lastUserUUIDForUserTexture.equals(userUUID)) {
            log.error("Ignore duplicated user texture request for {}!", (Object)userUUID);
            return null;
        }
        lastUserUUIDForUserTexture = userUUID;
        String sessionURL = String.format(SESSION_PROFILE_URL, userUUID);
        try {
            String data = IOUtils.toString((URL)new URL(sessionURL), (Charset)StandardCharsets.UTF_8);
            if (data == null || data.isEmpty()) {
                log.error("Unable to get user texture with {}", (Object)sessionURL);
                return null;
            }
            return PlayersUtils.getUserTextureFromSessionResponse(data);
        }
        catch (IOException ioException) {
            log.error("Unable to get user texture with {}:", (Object)sessionURL, (Object)ioException);
            return null;
        }
    }

    public static String getUserTextureFromSessionResponse(String data) {
        JsonObject jsonObject = PlayersUtils.getJsonObject(data);
        if (jsonObject == null || !jsonObject.has("properties")) {
            log.error("Unable to get valid JSON data from session response: {}", (Object)data);
            return "";
        }
        JsonArray properties = jsonObject.getAsJsonArray("properties");
        log.debug("getUserTextureFromSessionRequest: {}", (Object)properties);
        for (JsonElement property : properties) {
            JsonObject propertyObject = property.getAsJsonObject();
            if (!propertyObject.has("name") || !TEXTURES_STRING.equals(propertyObject.get("name").getAsString()) || !propertyObject.has("value")) continue;
            String textureData = new String(Base64.getDecoder().decode(propertyObject.get("value").getAsString()));
            String userTexture = PlayersUtils.getUserTextureFromTextureData(textureData);
            String userTextureModel = PlayersUtils.getUserTextureModelFromTextureData(textureData);
            log.debug("Found user texture {} with model {} ...", (Object)userTexture, (Object)(userTextureModel == null || userTextureModel.isEmpty() ? "default" : userTextureModel));
            return userTexture;
        }
        log.error("Unable to get user texture from session response: {}", (Object)data);
        return "";
    }

    public static String getUserTextureFromTextureData(String data) {
        JsonObject skinObject;
        JsonObject textureObject;
        JsonObject jsonObject = PlayersUtils.getJsonObject(data);
        log.debug("getUserTextureFromTextureData: {}", (Object)jsonObject);
        if (jsonObject != null && jsonObject.has(TEXTURES_STRING) && (textureObject = jsonObject.getAsJsonObject(TEXTURES_STRING)).has("SKIN") && (skinObject = textureObject.getAsJsonObject("SKIN")).has("url")) {
            return skinObject.get("url").getAsString();
        }
        log.error("Unable to get user texture from texture data: {}", (Object)data);
        return "";
    }

    public static String getUserTextureModelFromTextureData(String data) {
        JsonObject metaDataObject;
        JsonObject skinObject;
        JsonObject textureObject;
        JsonObject jsonObject = PlayersUtils.getJsonObject(data);
        log.debug("getUserTextureModelFromTextureData: {}", (Object)jsonObject);
        if (jsonObject != null && jsonObject.has(TEXTURES_STRING) && (textureObject = jsonObject.getAsJsonObject(TEXTURES_STRING)).has("SKIN") && (skinObject = textureObject.getAsJsonObject("SKIN")).has("metadata") && (metaDataObject = skinObject.getAsJsonObject("metadata")).has("model")) {
            return metaDataObject.get("model").getAsString();
        }
        log.debug("Unable to get user texture model from texture data: {}", (Object)data);
        return "";
    }

    public static JsonObject getJsonObject(String data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        try {
            JsonElement jsonElement = JsonParser.parseString((String)data);
            if (jsonElement != null && jsonElement.isJsonObject()) {
                return jsonElement.getAsJsonObject();
            }
        }
        catch (JsonParseException jsonParseException) {
            log.error("ERROR: Unable to parse json data: {}", (Object)data);
        }
        return null;
    }
}

